package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DomainsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.DomainsDictRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Domains.DOMAINS;

/**
 * Created by pashkus on 23.06.16.
 */

public class DomainsSteps extends BasePpcSteps {

    @Step("DB: получение записи из ppc.domains для domain = {0}")
    public DomainsRecord getDomainsRecord(String domain) {
        return exec(db -> db.selectFrom(DOMAINS)
                        .where(DOMAINS.DOMAIN.eq(domain))
                        .fetchOne());
    }

    @Step("DB: получение записи из ppc.domains для domainId = {0}")
    public DomainsRecord getDomainsDictRecord(Long domainId) {
        return exec(db ->
                db.selectFrom(DOMAINS)
                        .where(DOMAINS.DOMAIN_ID.eq(domainId))
                        .fetchOne());
    }

    @Step("DB: получение domain из ppc.domains для domain = {0}")
    public DomainsRecord getDomain(String domain) {
        return exec(db ->
                db.selectFrom(DOMAINS)
                        .where(DOMAINS.DOMAIN.eq(domain))
                        .fetchOne());
    }

    @Step("DB: запись в ppc.domains")
    public void createDomain(Long id, String domain) {
        exec(db ->
                db.insertInto(DOMAINS)
                        .set(new DomainsRecord().setDomain(domain).setDomainId(id))
                        .execute());
    }

    @Step("DB: удаление из ppc.domains")
    public void deleteDomain(Long... ids) {
        exec(db ->
                db.deleteFrom(DOMAINS)
                        .where(DOMAINS.DOMAIN_ID.in(ids))
                        .execute());
    }
}
