package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import javax.util.streamex.StreamEx;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DynamicConditionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.not;
import static org.hamcrest.collection.IsEmptyCollection.empty;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.DYNAMIC_CONDITIONS;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class DynamicConditionsSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.dynamic_conditions (dyn_cond_id = {0})")
    public DynamicConditionsRecord getDynamicConditions(long dynCondId) {
        DynamicConditionsRecord record = exec(db -> db.selectFrom(DYNAMIC_CONDITIONS)
                .where(DYNAMIC_CONDITIONS.DYN_COND_ID.eq(dynCondId))
                .fetchOne()
        );
        String logRecord = JsonUtils.toStringLow(record.intoMap());
        getLogger().info("полученная запись из таблицы ppc.dynamic_conditions: " + logRecord);
        addJsonAttachment("полученная запись", logRecord);
        return record;
    }

    @Step("DB: изменение записи в таблице ppc.dynamic_conditions")
    public int updateDynamicConditions(DynamicConditionsRecord dynamicConditions) {
        return exec(db -> db.update(DYNAMIC_CONDITIONS)
                .set(dynamicConditions)
                .where(DYNAMIC_CONDITIONS.DYN_COND_ID.eq(dynamicConditions.getDynCondId()))
                .execute()
        );
    }

    @Step("DB: получение записей из таблицы ppc.dynamic_conditions по pid: {0}")
    public List<DynamicConditionsRecord> getDynamicConditionsByAdgroupId(long adgroupId) {
        List<DynamicConditionsRecord> conditions  = exec(db -> db.selectFrom(DYNAMIC_CONDITIONS)
                .where(DYNAMIC_CONDITIONS.PID.eq(adgroupId))
                .fetch()
        );
        assumeThat("список полученных из базы условий нацеливания не пустой", conditions, not(empty()));
        return conditions;
    }

    @Step("DB: получение записи из таблицы ppc.dynamic_conditions по pid: {0}")
    public DynamicConditionsRecord getDynamicConditionByAdgroupId(long adgroupId) {
        List<DynamicConditionsRecord> conditions = getDynamicConditionsByAdgroupId(adgroupId);
        DynamicConditionsRecord condition = conditions.get(0);
        String logRecord = JsonUtils.toStringLow(condition.intoMap());
        getLogger().info("полученная запись из таблицы ppc.dynamic_conditions: " + logRecord);
        addJsonAttachment("полученная запись", logRecord);
        return condition;
    }

    @Step("DB: удаление записей из таблицы ppc.dynamic_conditions по pid: {0}")
    public void deleteDynamicConditionsByPid(long adgroupId) {
        List<DynamicConditionsRecord> conditions = getDynamicConditionsByAdgroupId(adgroupId);
        List<Long> dynCondIds = StreamEx.of(conditions).map(DynamicConditionsRecord::getDynCondId).toList();
        exec(db -> db.delete(DYNAMIC_CONDITIONS)
                .where(DYNAMIC_CONDITIONS.DYN_COND_ID.in(dynCondIds))
        );
    }
}
