package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.EventlogRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.EVENTLOG;

/**
 * Степы для работы с таблицей ppc.eventlog
 */
public class EventLogSteps extends BasePpcSteps {

    @Step("DB: получение записей из таблицы ppc.eventlog по ClientID:{0} и cid:{1}")
    public List<EventlogRecord> getEventLogsByCid(Long clientId, Long cid) {
        return exec(db -> db.selectFrom(EVENTLOG)
                .where(EVENTLOG.CLIENTID.eq(clientId)
                        .and(EVENTLOG.CID.eq(cid)))
                .fetch());
    }

    @Step("DB: изменить время всех ивентов в таблице ppc.eventlog по ClientID:{0}, новое время:{1}")
    public void moveAllEventsInTime(Long clientId, String newTime) {
        exec(db -> db.update(EVENTLOG)
                .set(EVENTLOG.EVENTTIME, Timestamp.valueOf(newTime))
                .where(EVENTLOG.CLIENTID.eq(clientId))
                .execute());
    }

    @Step("DB: изменить время всех ивентов в таблице ppc.eventlog по ClientID:{0} и cid:{1}, новое время:{2}")
    public void moveAllEventsInTime(Long clientId, Long cid, String newTime) {
        exec(db -> db.update(EVENTLOG)
                .set(EVENTLOG.EVENTTIME, Timestamp.valueOf(newTime))
                .where(EVENTLOG.CLIENTID.eq(clientId)
                        .and(EVENTLOG.CID.eq(cid)))
                .execute());
    }

    @Step("DB: удалить все ивенты из таблицы ppc.eventlog по ClientID:{0}")
    public void deleteAllEvents(Long clientId) {
        exec(db -> db.deleteFrom(EVENTLOG)
                .where(EVENTLOG.CLIENTID.eq(clientId))
                .execute());
    }

    @Step("DB: добавить событие в таблицу ppc.eventlog")
    public void addEvent(EventlogRecord record) {
        exec(db -> db.insertInto(EVENTLOG)
                .set(record)
                .execute());
    }
}
