package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ExperimentsStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsExperimentsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ExperimentsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.sql.Date;
import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampaignsExperiments.CAMPAIGNS_EXPERIMENTS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Experiments.EXPERIMENTS;

public class ExperimentsSteps extends BasePpcSteps {
    @Step("DB: получение записи в таблице ppc.experiments по experiment_id: {0}")
    public ExperimentsRecord getExperimentsRecord(Long experimentId) {
        return exec(db -> db.selectFrom(EXPERIMENTS)
                .where(EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .fetchOne()
        );
    }

    @Step("DB: получение записей в таблице ppc.experiments по ClientID: {0}")
    public List<ExperimentsRecord> getExperimentsRecordsByClientId(Long clientId) {
        return exec(db -> db.selectFrom(EXPERIMENTS)
                .where(EXPERIMENTS.CLIENTID.eq(clientId))
                .fetch()
        );
    }

    @Step("DB: выставление эксперименту с id: {0} даты начала: {1}")
    public void setExperimentsDateFrom(Long experimentId, Date dateFrom) {
        run(db -> db.update(EXPERIMENTS)
                .set(EXPERIMENTS.DATE_FROM, dateFrom)
                .where(EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .execute()
        );
    }

    @Step("DB: выставление эксперименту с id: {0} даты окончания: {1}")
    public void setExperimentsDateTo(Long experimentId, Date dateTo) {
        run(db -> db.update(EXPERIMENTS)
                .set(EXPERIMENTS.DATE_TO, dateTo)
                .where(EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .execute()
        );
    }

    @Step("DB: выставление эксперименту с id: {0} значения percent: {1}")
    public void setExperimentsPercent(Long experimentId, Integer percent) {
        run(db -> db.update(EXPERIMENTS)
                .set(EXPERIMENTS.PERCENT, percent)
                .where(EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .execute()
        );
    }

    @Step("DB: выставление эксперименту с id: {0} статуса: {1}")
    public void setExperimentsStatus(Long experimentId, ExperimentsStatus status) {
        run(db -> db.update(EXPERIMENTS)
                .set(EXPERIMENTS.STATUS, status)
                .where(EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.campaigns_experiments по cid: {0}")
    public CampaignsExperimentsRecord getCampaignsExperimentsRecord(Long cid) {
        return exec(db -> db.selectFrom(CAMPAIGNS_EXPERIMENTS)
                .where(CAMPAIGNS_EXPERIMENTS.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: получение записей в таблице ppc.campaigns_experiments по experiment_id: {0}")
    public List<CampaignsExperimentsRecord> getCampaignsExperimentsRecords(Long experimentId) {
        return exec(db -> db.selectFrom(CAMPAIGNS_EXPERIMENTS)
                .where(CAMPAIGNS_EXPERIMENTS.EXPERIMENT_ID.eq(experimentId))
                .fetch()
        );
    }


}
