package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.FEATURES;

/**
 * Created by adubinkin on 17/05/18.
 */
public class FeaturesSteps extends BasePpcDictSteps {

    @Step("DB: получение идентификатора фичи {0}")
    public long getFeatureId(String featureName) {
        return exec(db -> db.select(FEATURES.FEATURE_ID).from(FEATURES)
                .where(FEATURES.FEATURE_TEXT_ID.eq(featureName))
                .fetchOne().value1());
    }

    @Step("DB: включить клиенту {0} фичу {0}")
    public void ensureClientHasFeature(Long clientId, String featureName) {
        long featureId = getFeatureId(featureName);

        BaseSteps.getInstance(ClientsSteps.class, getContext())
                .setClientFeature(clientId, featureId, true);
    }

    @Step("DB: включить клиенту {0} фичу {0}, если не включена")
    public void ensureClientHasFeatureIfNotSet(Long clientId, String featureName) {
        long featureId = getFeatureId(featureName);
        boolean isEnabled = BaseSteps.getInstance(ClientsSteps.class, getContext())
                .isFeatureEnabled(clientId, featureId);
        if (!isEnabled) {
            BaseSteps.getInstance(ClientsSteps.class, getContext())
                    .setClientFeature(clientId, featureId, true);
        }
    }

    @Step("DB: выставить клиенту {0} флаг фичи {0} в значение {0}")
    public void setClientFeature(Long clientId, String featureName, boolean isFeatureEnabled) {
        long featureId = getFeatureId(featureName);

        BaseSteps.getInstance(ClientsSteps.class, getContext())
                .setClientFeature(clientId, featureId, isFeatureEnabled);
    }
}
