package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.FilteredFeedsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.FilteredFeeds.FILTERED_FEEDS;

public class FilteredFeedsSteps extends BasePpcSteps {

    @Step("DB: получение записей из таблицы ppc.filtered_feeds (filtered_feed_id = {0})")
    public List<FilteredFeedsRecord> getFilteredFeeds(Long filteredFeedId) {
        return exec(db -> db.selectFrom(FILTERED_FEEDS)
                .where(FILTERED_FEEDS.FILTERED_FEED_ID.eq(filteredFeedId))
                .fetch());
    }

    @Step("DB: получение записей из таблицы ppc.filtered_feeds (feedId = {0})")
    public List<FilteredFeedsRecord> getFilteredFeedsByFeedId(Long feedId) {
        return exec(db -> db.selectFrom(FILTERED_FEEDS)
                .where(FILTERED_FEEDS.FEED_ID.eq(feedId))
                .fetch());
    }

}
