package ru.yandex.autotests.direct.db.steps;

import java.sql.Date;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ForceCurrencyConvertRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ForceCurrencyConvert.FORCE_CURRENCY_CONVERT;

/**
 * Created by buhter on 30/05/16.
 */
public class ForceCurrencyConvertSteps extends BasePpcSteps {
    @Step("DB: получение записи из таблицы ppc.force_currency_convert (clientId = {0})")
    public ForceCurrencyConvertRecord getForceCurrencyConvert(Long clientId) {
        return exec(db -> db.selectFrom(FORCE_CURRENCY_CONVERT)
                .where(FORCE_CURRENCY_CONVERT.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.force_currency_convert")
    public void createForceCurrencyConvert(ForceCurrencyConvertRecord record) {
        exec(db -> db.insertInto(FORCE_CURRENCY_CONVERT)
                .set(record)
                .execute());
    }

    @Step("DB: изменение даты конвертации клиента в таблице ppc.force_currency_convert (ClientID = {0})")
    public void updateConvertDate(long clientId, Date convertDate) {
        ForceCurrencyConvertRecord record = getForceCurrencyConvert(clientId);
        record.setConvertDate(convertDate);
        getLogger().info("обновление записи в таблице ppc.force_currency_convert: " + record.intoMap());
        exec(db -> db.update(FORCE_CURRENCY_CONVERT)
                .set(record)
                .execute());
    }

    @Step("DB: удаление записи в таблице ppc.force_currency_convert")
    public void deleteForceCurrencyConvert(Long clientId) {
        exec(db -> db.deleteFrom(FORCE_CURRENCY_CONVERT)
                .where(FORCE_CURRENCY_CONVERT.CLIENTID.eq(clientId))
                .execute());
    }
}
