package ru.yandex.autotests.direct.db.steps;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FreelancersCardStatusModerate;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.FREELANCERS_CARD;

public class FreelancerCardSteps extends BasePpcSteps {

    @Step("DB: > Принятие на модерации последней карточки фрилансера clientId: {0}")
    public void acceptFreelancerLastCard(Long clientId) {
        Long lastCardId = getFreelancerLastCard(clientId);

        exec(db -> db.update(FREELANCERS_CARD)
                .set(FREELANCERS_CARD.STATUS_MODERATE, FreelancersCardStatusModerate.accepted)
                .set(FREELANCERS_CARD.DECLINE_REASON, StringUtils.EMPTY)
                .where(FREELANCERS_CARD.FREELANCERS_CARD_ID
                        .eq(lastCardId))
                .execute()
        );
    }

    @Step("DB: > Получение последней карточки фрилансера: {0}")
    public Long getFreelancerLastCard(Long clientId) {
        return exec(db -> db.selectFrom(FREELANCERS_CARD)
                .where(FREELANCERS_CARD.CLIENTID.eq(clientId))
                .orderBy(FREELANCERS_CARD.FREELANCERS_CARD_ID.desc())
                .limit(1)
                .fetchOne(FREELANCERS_CARD.FREELANCERS_CARD_ID));
    }
}
