package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FreelancersProjectsStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.FreelancersProjectsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CLIENTS_RELATIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.FreelancersProjects.FREELANCERS_PROJECTS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Users.USERS;

public class FreelancerProjectSteps extends BasePpcSteps {

    @Step("DB: > Завершение сотрудничества для клиента: {0}")
    public void cancelCooperationByFreelancer(String clientLogin) {
        Long clientId = exec(db -> db.select(USERS.CLIENTID)
                .from(USERS)
                .where(USERS.LOGIN.eq(clientLogin)).fetchOne())
                .value1();

        updateFreelancersProjects(
                new FreelancersProjectsRecord()
                        .setStatus(FreelancersProjectsStatus.CancelledByFreelancer), clientId);

        deleteRecordFromClientRelationByClientId(clientId);
    }

    @Step("DB: > обновление записи в ppc.freelancers_projects для клиента clientId: {1}")
    public void updateFreelancersProjects(FreelancersProjectsRecord freelancersProjectsRecord, Long clientId) {
        exec(db -> db.update(FREELANCERS_PROJECTS)
                .set(freelancersProjectsRecord)
                .where(FREELANCERS_PROJECTS.CUSTOMER_CLIENT_ID.eq(clientId))
                .execute());

    }

    @Step("DB: > удаление записи из ppc.clients_relations для клиента clientId: {0}")
    public void deleteRecordFromClientRelationByClientId(Long clientId) {
        exec(db -> db.deleteFrom(CLIENTS_RELATIONS).where(CLIENTS_RELATIONS.CLIENT_ID_TO.eq(clientId)).execute());
    }
}
