package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_HYPERGEO_RETARGETINGS;

public class HyperGeoSteps extends BasePpcSteps {

    @Step("DB: привязываем к группе pid: {0} гипер гео с id: {1}")
    public int addHyperGeoToAdGroup(Long adGroupId, Long hyperGeoRetargetingId) {
        return exec(db -> db.insertInto(ADGROUPS_HYPERGEO_RETARGETINGS)
                .set(ADGROUPS_HYPERGEO_RETARGETINGS.PID, adGroupId)
                .set(ADGROUPS_HYPERGEO_RETARGETINGS.RET_COND_ID, hyperGeoRetargetingId)
                .onDuplicateKeyUpdate()
                .set(ADGROUPS_HYPERGEO_RETARGETINGS.RET_COND_ID, hyperGeoRetargetingId)
                .execute());
    }
}
