package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.InfoblockTeasersFactorsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.InfoblockTeasersFactors.INFOBLOCK_TEASERS_FACTORS;


public class InfoblockTeasersFactorsSteps extends BasePpcSteps {

    @Step("DB: получение записи из ppc.infoblock_teasers_factors по clientId {0}")
    public InfoblockTeasersFactorsRecord getInfoBlockTeaserFactorsRecords(Long clientId) {
        return exec(db -> db.selectFrom(INFOBLOCK_TEASERS_FACTORS)
                .where(INFOBLOCK_TEASERS_FACTORS.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: обновление записи в ppc.infoblock_teasers_factors")
    public void updateInfoBlockTeaserFactors(InfoblockTeasersFactorsRecord record) {
        exec(db -> db.update(INFOBLOCK_TEASERS_FACTORS)
                .set(record)
                .where(INFOBLOCK_TEASERS_FACTORS.CLIENTID.eq(record.getClientid()))
                .execute());
    }
}
