package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IosSkadnetworkSlots.IOS_SKADNETWORK_SLOTS;

public class IosSkAdNetworkSteps extends BasePpcDictSteps {
    public void deleteSlotsForCampaign(Long cid) {
        exec(db -> db.deleteFrom(IOS_SKADNETWORK_SLOTS).where(IOS_SKADNETWORK_SLOTS.CID.eq(cid)));
    }

    public void allocateSlotWithReplace(String bundleId, Long cid, Long slot) {
        exec(
                db -> db.insertInto(IOS_SKADNETWORK_SLOTS)
                        .set(IOS_SKADNETWORK_SLOTS.BUNDLE_ID, bundleId)
                        .set(IOS_SKADNETWORK_SLOTS.CID, cid)
                        .set(IOS_SKADNETWORK_SLOTS.SLOT, slot.shortValue())
                        .onDuplicateKeyUpdate()
                        .set(IOS_SKADNETWORK_SLOTS.CID, cid)
                        .execute()
        );
    }
}
