package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.LalSegments;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.LalSegmentsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class LalSegmentsSteps extends BasePpcDictSteps {
    public LalSegmentsSteps() {
    }

    @Step("DB: добавление или изменение цели в таблице ppcdict.lal_segments")
    public void addOrUpdateLalSegment(LalSegmentsRecord lalSegmentsRecord) {
        this.run(db -> db.insertInto(LalSegments.LAL_SEGMENTS)
                .set(LalSegments.LAL_SEGMENTS.PARENT_GOAL_ID, lalSegmentsRecord.getParentGoalId())
                .set(LalSegments.LAL_SEGMENTS.IS_ACTIVE, lalSegmentsRecord.getIsActive())
                .onDuplicateKeyUpdate()
                .set(lalSegmentsRecord)
                .execute());
    }

    @Step("DB: поиск цели в таблице ppcdict.lal_segments по parent_id")
    public LalSegmentsRecord findLalSegmentByParent(long parentId) {
        return this.exec(db -> db.selectFrom(LalSegments.LAL_SEGMENTS)
                .where(LalSegments.LAL_SEGMENTS.PARENT_GOAL_ID.eq(parentId))
                .fetchOne());
    }
}
