package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MarketRatingsRecord;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.MarketRatings.MARKET_RATINGS;

public class MarketRatingsSteps extends BasePpcDictSteps {

    @Step("DB: получение записи из ppcdict.market_ratings для domainId = {0}")
    public MarketRatingsRecord getMarketRatingsRecord(Long domainId) {
        return exec(db ->
                db.selectFrom(MARKET_RATINGS)
                        .where(MARKET_RATINGS.DOMAIN_ID.eq(domainId))
                        .fetchOne());
    }

    @Step("DB: запись в таблицу ppcdict.market_ratings")
    public MarketRatingsRecord updateMarketRatingsRecord(MarketRatingsRecord marketRatingsRecord) {
        return exec(db ->
                db.update(MARKET_RATINGS)
                        .set(marketRatingsRecord).returning()
                        .fetchOne());
    }

    @Step("DB: удаление из таблицы ppcdict.domains_dict")
    public void deleteMarketRatings(Long... domainIds) {
        exec(db ->
                db.deleteFrom(MARKET_RATINGS)
                        .where(MARKET_RATINGS.DOMAIN_ID.in(domainIds))
                        .execute());
    }
}
