package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.MediaResourcesResourceType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MediaResourcesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.MediaResources.MEDIA_RESOURCES;

/**
 * Created by n-boy on 16.12.16.
 * набор степов для работы с таблицей ppcdict.media_resources
 */
public class MediaResourcesSteps extends BasePpcDictSteps {

    @Step("DB: получение записи из ppcdict.media_resources по mediaResourceId: {0}")
    public MediaResourcesRecord getMediaResource(Long mediaResourceId) {
        return exec(db -> db.selectFrom(MEDIA_RESOURCES)
                        .where(MEDIA_RESOURCES.MEDIA_RESOURCE_ID.eq(mediaResourceId))
                        .fetchOptional()
                        .orElse(null));
    }

    @Step("DB: создание записи в таблице ppcdict.media_resources")
    public MediaResourcesRecord createMediaResource(MediaResourcesRecord mediaResource) {
        return exec(db -> db.insertInto(MEDIA_RESOURCES)
                        .set(mediaResource)
                        .returning()
                        .fetchOne());
    }

    @Step("DB: создание записи в таблице ppcdict.media_resources, с параметрами видеоресурса по-умолчанию")
    public MediaResourcesRecord createDefaultVideoResource() {
        MediaResourcesRecord mediaResource = new MediaResourcesRecord()
                                                      .setResourceType(MediaResourcesResourceType.video)
                                                      .setName("Default test video resource")
                                                      .setColors("")
                                                      .setPreviewUrl("[]")
                                                      .setResourcesUrl("[]");
        return createMediaResource(mediaResource);
    }

    @Step("DB: удаление записи из ppcdict.media_resources")
    public void deleteMediaResource(Long mediaResourceId) {
        run(db -> db.deleteFrom(MEDIA_RESOURCES)
                .where(
                        MEDIA_RESOURCES.MEDIA_RESOURCE_ID.eq(mediaResourceId)
                ).execute());
    }
}
