package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MetrikaCountersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.MetrikaCounters.METRIKA_COUNTERS;

public class MetrikaCountersSteps extends BasePpcSteps {

    public MetrikaCountersRecord getMetrikaCounters(Long cid, Long metrikaCounter) {
        return exec("DB: получение записи из таблицы ppc.metrika_counters (cid = {0}, metrikaCounter = {1})",
                db -> db.selectFrom(METRIKA_COUNTERS)
                        .where(METRIKA_COUNTERS.CID.eq(cid)
                                .and(METRIKA_COUNTERS.METRIKA_COUNTER.eq(metrikaCounter)))
                        .fetchOne());
    }

    public MetrikaCountersRecord getMetrikaCounters(Long cid) {
        return exec("DB: получение записи из таблицы ppc.metrika_counters (cid = {0})",
                db -> db.selectFrom(METRIKA_COUNTERS)
                        .where(METRIKA_COUNTERS.CID.eq(cid))
                        .fetchOne());
    }

    public List<MetrikaCountersRecord> getAllMetrikaCountersByCid(Long cid) {
        return exec("DB: получение записей из таблицы ppc.metrika_counters (cid = {0})",
                db -> db.selectFrom(METRIKA_COUNTERS)
                        .where(METRIKA_COUNTERS.CID.eq(cid))
                        .fetch());
    }

    public void updateMetrikaCounters(MetrikaCountersRecord metrikaCountersRecord) {
        run("DB: изменение записи в таблице ppc.metrika_counters",
                db -> db.update(METRIKA_COUNTERS)
                        .set(metrikaCountersRecord)
                        .where(METRIKA_COUNTERS.CID.eq(metrikaCountersRecord.getCid())
                                .and(METRIKA_COUNTERS.METRIKA_COUNTER.eq(metrikaCountersRecord.getMetrikaCounter())))
                        .execute()
        );
    }

    public void createMetrikaCounters(MetrikaCountersRecord metrikaCountersRecord) {
        run("DB: добавление записи в таблицу ppc.metrika_counters",
                db -> db.insertInto(METRIKA_COUNTERS)
                        .set(metrikaCountersRecord)
                        .execute()
        );
    }

    public void deleteMetrikaCounters(Long cid, Long metrikaCounter) {
        run("DB: удаление записи из таблице ppc.metrika_counters cid=" + cid + "; metrikaCounter = " + metrikaCounter,
                db -> db.deleteFrom(METRIKA_COUNTERS)
                        .where(METRIKA_COUNTERS.CID.eq(cid)
                                .and(METRIKA_COUNTERS.METRIKA_COUNTER.eq(metrikaCounter)))
                        .execute()
        );
    }

    @Step("обновление записи metrika_counters cid = {0}, metrikaCounter = {1}, hasEcommerce = {2}")
    public void updateMetrikaCountersEcommerce(Long cid, Long metrikaCounter, Integer isDeleted, Integer hasEcommerce) {
        MetrikaCountersRecord metrikaCountersRecord = getMetrikaCounters(cid, metrikaCounter);
        metrikaCountersRecord.setIsDeleted(isDeleted);
        metrikaCountersRecord.setHasEcommerce(hasEcommerce);
        updateMetrikaCounters(metrikaCountersRecord);
    }

    @Step("добавление записи metrika_counters cid = {0}, metrikaCounter = {1}, isDeleted = {2}, hasEcommerce = {3}")
    public void createMetrikaCounters(Long cid, Long metrikaCounter, Integer isDeleted, Integer hasEcommerce) {
        MetrikaCountersRecord metrikaCountersRecord = new MetrikaCountersRecord();
        metrikaCountersRecord.setCid(cid);
        metrikaCountersRecord.setMetrikaCounter(metrikaCounter);
        metrikaCountersRecord.setHasEcommerce(hasEcommerce);
        metrikaCountersRecord.setIsDeleted(isDeleted);
        createMetrikaCounters(metrikaCountersRecord);
    }
}
