package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MetrikaGoalsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.MetrikaGoals.METRIKA_GOALS;

public class MetrikaGoalsSteps extends BasePpcDictSteps {
    @Step("DB: чтение из таблицы ppcdict.metrika_goals, goal_id: {0}")
    public MetrikaGoalsRecord getMetrikaGoals(Long goalId) {
        return exec(db ->
                db.selectFrom(METRIKA_GOALS)
                        .where(METRIKA_GOALS.GOAL_ID.eq(goalId))
                        .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppcdict.metrika_goals по goal_id: {0}")
    public List<MetrikaGoalsRecord> getMetrikaGoalsList(Long... goalIds) {
        return exec(db ->
                db.selectFrom(METRIKA_GOALS)
                        .where(METRIKA_GOALS.GOAL_ID.in(goalIds))
                        .fetch());
    }

    @Step("DB: удаление из таблицы ppcdict.metrika_goals, gaol_ids: {0}")
    public void deleteMetrikaGoals(Long... goalIds) {
        run(db ->
                db.deleteFrom(METRIKA_GOALS)
                        .where(METRIKA_GOALS.GOAL_ID.in(goalIds))
                        .execute());
    }

}
