package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MinusWordsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MINUS_WORDS;

/**
 * Created by andy-ilyin on 12.09.16.
 */
public class MinusWordsSteps extends BasePpcSteps {
    @Step("DB: получение записи в таблице ppc.minus_words по mw_id: {0}")
    public MinusWordsRecord getMinusWords(Long mwId) {
        return exec(db -> db.selectFrom(MINUS_WORDS).where(MINUS_WORDS.MW_ID.eq(mwId)).fetchOne());
    }

    @Step("DB: получение записей из таблицы ppc.minus_words по clientId: {0}")
    public List<MinusWordsRecord> getMinusWordsBiClientId(Long clientId) {
        return exec(db -> db.selectFrom(MINUS_WORDS).where(MINUS_WORDS.CLIENTID.eq(clientId)).fetch());
    }

    @Step("DB: создание записи в таблице ppc.minus_words с mw_id: {0}, ClientID: {1}, mw_text: {2}")
    public Long createRecord(Long clientId, String mwText) {
        Long mwId = autoIncSteps().getNewMwId();
        run(db -> db
                .insertInto(MINUS_WORDS)
                .set(new MinusWordsRecord()
                        .setMwId(mwId)
                        .setClientid(clientId)
                        .setMwText(mwText)
                        .setMwHash(BigInteger.ZERO))
                .execute());
        return mwId;
    }

    @Step("DB: создание записи в таблице ppc.minus_words ClientID: {0}, mw_text: {1}")
    public Long addLibMinusWord(Long clientId, String mwText) {
        Long mwId = autoIncSteps().getNewMwId();
        run(db -> db
                .insertInto(MINUS_WORDS)
                .set(new MinusWordsRecord()
                        .setMwId(mwId)
                        .setClientid(clientId)
                        .setMwText(mwText)
                        .setMwHash(BigInteger.ZERO)
                        .setIsLibrary(1))
                .execute());
        return mwId;
    }

    @Step("DB: создание записи в таблице ppc.minus_words ClientID: {0}, mw_text: {1}, mw_name: {2}")
    public Long addLibMinusWordWithName(Long clientId, List<String> minusWordsList, String mwName) {
        Long mwId = autoIncSteps().getNewMwId();
        run(db -> db
                .insertInto(MINUS_WORDS)
                .set(new MinusWordsRecord()
                        .setMwId(mwId)
                        .setClientid(clientId)
                        .setMwText(JsonUtils.toString(minusWordsList, true))
                        .setMwName(mwName)
                        .setMwHash(BigInteger.ZERO)
                        .setIsLibrary(1))
                .execute());
        return mwId;
    }

    @Step("DB: удаление записи в таблице ppc.minus_words с mw_id: {0}")
    public void deleteRecord(Long mwId) {
        run(db -> db.deleteFrom(MINUS_WORDS).where(MINUS_WORDS.MW_ID.eq(mwId)).execute());
    }
}
