package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MirrorsCorrectionRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MirrorsNewRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MirrorsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.Mirrors.MIRRORS;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.MirrorsCorrection.MIRRORS_CORRECTION;

public class MirrorsSteps extends BasePpcDictSteps {

    @Step("DB: чтение из таблицы ppcdict.mirrors, domains: {0}")
    public List<MirrorsRecord> getMirrors(String... domains) {
        return exec(db ->
                db.selectFrom(MIRRORS)
                        .where(MIRRORS.DOMAIN.in(domains))
                        .fetch());
    }

    @Step("DB: запись в таблицу ppcdict.mirrors")
    public void createMirrors(MirrorsRecord mirrors) {
        exec(db -> db.insertInto(MIRRORS)
                .set(mirrors)
                .execute());
    }

    @Step("DB: удаление из таблицы ppcdict.mirrors, domains: {0}")
    public void deleteMirrors(String... domains) {
        exec(db -> db.deleteFrom(MIRRORS)
                .where(MIRRORS.DOMAIN.in(domains))
                .execute());
    }

    @Step("DB: чтение из таблицы ppcdict.mirrors_correction, domains: {0}")
    public List<MirrorsCorrectionRecord> getMirrorsCorrections(String... domains) {
        return exec(db ->
                db.selectFrom(MIRRORS_CORRECTION)
                        .where(MIRRORS_CORRECTION.DOMAIN.in(domains))
                        .fetch());
    }

    @Step("DB: запись в таблицу ppcdict.mirrors_correction")
    public void createMirrorsCorrection(MirrorsCorrectionRecord mirrorsCorrectionRecord) {
        exec(db -> db.insertInto(MIRRORS_CORRECTION)
                .set(mirrorsCorrectionRecord)
                .execute());
    }

    @Step("DB: удаление из таблицы ppcdict.mirrors_correction, domains: {0}")
    public void deleteMirrorsCorrection(String... domains) {
        exec(db -> db.deleteFrom(MIRRORS_CORRECTION)
                .where(MIRRORS_CORRECTION.DOMAIN.in(domains))
                .execute());
    }


}
