package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.*;

/**
 * Created by buhter on 01/09/16.
 */
public class MobileContentSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.mobile_content (mobile_content_id = {0}")
    public MobileContentRecord getMobileContent(Long mobileContentId) {
        return exec(db ->
                db.selectFrom(MOBILE_CONTENT)
                        .where(MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(mobileContentId))
                        .fetchOne());
    }

    @Step("DB: удаление записей в ppc.mobile_content (mobile_content_id = {0}")
    public void deleteMobileContent(Long mobileContentId) {
        run(db ->
                db.deleteFrom(MOBILE_CONTENT)
                        .where(MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(mobileContentId))
                        .execute());
    }

    public void deleteMobileContent(MobileContentRecord mobileContent) {
        deleteMobileContent(mobileContent.getMobileContentId());
    }

    @Step("DB: изменение записи в таблице ppc.mobile_content")
    public void updateMobileContent(MobileContentRecord mobileContent) {
        run(db ->
                db.update(MOBILE_CONTENT)
                        .set(mobileContent)
                        .where(MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(mobileContent.getMobileContentId()))
                        .execute());
    }

    @Step("DB: создание записи в таблице ppc.mobile_content")
    public Long saveMobileContent(MobileContentRecord mobileContent) {
        Long mobileContentId = autoIncSteps().getNewMobileContentId();
        run(db ->
                db.insertInto(MOBILE_CONTENT)
                        .set(mobileContent.setMobileContentId(mobileContentId))
                        .returning(MOBILE_CONTENT.fields())
                        .fetchOne());
        return mobileContentId;
    }

    //campaigns_mobile_content
    @Step("DB: получение записи в таблице ppc.campaigns_mobile_content, cid = {0}")
    public CampaignsMobileContentRecord getCampaignsMobileContent(Long cid) {
        return exec(db ->
                db.selectFrom(CAMPAIGNS_MOBILE_CONTENT)
                        .where(CAMPAIGNS_MOBILE_CONTENT.CID.eq(cid))
                        .fetchOne());

    }

    @Step("DB: создание записи в таблице ppc.campaigns_mobile_content")
    public void saveCampaignsMobileContent(CampaignsMobileContentRecord campaignsMobileContentRecord) {
        run(db ->
                db.insertInto(CAMPAIGNS_MOBILE_CONTENT)
                        .set(campaignsMobileContentRecord)
                        .returning(CAMPAIGNS_MOBILE_CONTENT.fields())
                        .fetchOne());

    }

    @Step("DB: изменение записи в таблице ppc.campaigns_mobile_content")
    public void updateCampaignsMobileContent(CampaignsMobileContentRecord campaignsMobileContentRecord) {
        run(db ->
                db.update(CAMPAIGNS_MOBILE_CONTENT)
                        .set(campaignsMobileContentRecord)
                        .where(CAMPAIGNS_MOBILE_CONTENT.CID.eq(campaignsMobileContentRecord.getCid()))
                        .execute());

    }

    @Step("DB: удаление записи из таблице ppc.campaigns_mobile_content")
    public void deleteCampaignsMobileContent(CampaignsMobileContentRecord campaignsMobileContentRecord) {
        run(db ->
                db.deleteFrom(CAMPAIGNS_MOBILE_CONTENT)
                        .where(CAMPAIGNS_MOBILE_CONTENT.CID.eq(campaignsMobileContentRecord.getCid()))
                        .execute());

    }

    //adgroups_mobile_content
    @Step("DB: получение записи в таблице ppc.adgroups_mobile_content, pid = {0}")
    public AdgroupsMobileContentRecord getAdgroupsMobileContent(Long pid) {
        return exec(db ->
                db.selectFrom(ADGROUPS_MOBILE_CONTENT)
                        .where(ADGROUPS_MOBILE_CONTENT.PID.eq(pid))
                        .fetchOne());

    }

    @Step("DB: получение записей в таблице ppc.adgroups_mobile_content, mobileContentId = {0}")
    public List<AdgroupsMobileContentRecord> getAdgroupsMobileContentByMobileContentId(Long mobileContentId) {
        return exec(db ->
                db.selectFrom(ADGROUPS_MOBILE_CONTENT)
                        .where(ADGROUPS_MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(mobileContentId))
                        .fetch());
    }

    @Step("DB: создание записи в таблице ppc.adgroups_mobile_content")
    public void saveAdgroupsMobileContent(AdgroupsMobileContentRecord adgroupsMobileContentRecord) {
        run(db ->
                db.insertInto(ADGROUPS_MOBILE_CONTENT)
                        .set(adgroupsMobileContentRecord)
                        .returning(ADGROUPS_MOBILE_CONTENT.fields())
                        .fetchOne());

    }

    @Step("DB: изменение записи в таблице ppc.adgroups_mobile_content")
    public void updateAdgroupsMobileContent(AdgroupsMobileContentRecord adgroupsMobileContentRecord) {
        run(db ->
                db.update(ADGROUPS_MOBILE_CONTENT)
                        .set(adgroupsMobileContentRecord)
                        .where(ADGROUPS_MOBILE_CONTENT.PID.eq(adgroupsMobileContentRecord.getPid()))
                        .execute());

    }

    @Step("DB: удаление записи из таблице ppc.adgroups_mobile_content")
    public void deleteAdgroupsMobileContent(AdgroupsMobileContentRecord adgroupsMobileContentRecord) {
        run(db ->
                db.deleteFrom(ADGROUPS_MOBILE_CONTENT)
                        .where(ADGROUPS_MOBILE_CONTENT.PID.eq(adgroupsMobileContentRecord.getPid()))
                        .execute());

    }

    //banners_mobile_content
    @Step("DB: получение записи в таблице ppc.banners_mobile_content, bid = {0}")
    public BannersMobileContentRecord getBannersMobileContent(Long bid) {
        return exec(db ->
                db.selectFrom(BANNERS_MOBILE_CONTENT)
                        .where(BANNERS_MOBILE_CONTENT.BID.eq(bid))
                        .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.banners_mobile_content")
    public void saveBannersMobileContent(BannersMobileContentRecord bannersMobileContentRecord) {
        run(db ->
                db.insertInto(BANNERS_MOBILE_CONTENT)
                        .set(bannersMobileContentRecord)
                        .returning(BANNERS_MOBILE_CONTENT.fields())
                        .fetchOne());
    }

    @Step("DB: изменение записи в таблице ppc.banners_mobile_content")
    public void updateBannersMobileContent(BannersMobileContentRecord bannersMobileContentRecord) {
        run(db ->
                db.update(BANNERS_MOBILE_CONTENT)
                        .set(bannersMobileContentRecord)
                        .where(BANNERS_MOBILE_CONTENT.BID.eq(bannersMobileContentRecord.getBid()))
                        .execute());
    }

    @Step("DB: удаление записи из таблице ppc.banners_mobile_content")
    public void deleteBannersMobileContent(BannersMobileContentRecord bannersMobileContentRecord) {
        run(db ->
                db.deleteFrom(BANNERS_MOBILE_CONTENT)
                        .where(BANNERS_MOBILE_CONTENT.BID.eq(bannersMobileContentRecord.getBid()))
                        .execute());
    }

}
