package ru.yandex.autotests.direct.db.steps;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModEditRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_EDIT;

@ParametersAreNonnullByDefault
public class ModEditSteps extends BasePpcSteps {

    @Step("DB: Добавление записи в таблице ppc.mod_edit")
    public void addModEdit(ModEditRecord modEditRecord) {
        run(db -> db.insertInto(MOD_EDIT)
                .set(modEditRecord)
                .execute());
    }
}
