package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatussending;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModReasonsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_REASONS;

public class ModReasonsSteps extends BasePpcSteps {
    @Step("DB: Добавление записи в таблице ppc.mod_reasons")
    public void addModReason(Long id, ModReasonsType type, ModReasonsStatussending statusSending,
            ModReasonsStatusmoderate statusModerate, ModReasonsStatuspostmoderate statusPostModerate,
            String timeCreated, List<Integer> reasons)
    {
        String reasonsStr = "---\n- " + reasons.stream().map(r -> String.format("\n id: %d\n", r)).collect(
                Collectors.joining("-"));
        ModReasonsRecord modReasonsRecord = new ModReasonsRecord()
                .setId(id)
                .setType(type)
                .setStatussending(statusSending)
                .setStatusmoderate(statusModerate)
                .setStatuspostmoderate(statusPostModerate)
                .setTimecreated(Timestamp.valueOf(timeCreated))
                .setReason(reasonsStr);
        addModReason(modReasonsRecord);
    }

    @Step("DB: Добавление записи в таблице ppc.mod_reasons")
    public void addModReason(ModReasonsRecord modReasonsRecord) {
        run(db -> db.insertInto(MOD_REASONS)
                .set(modReasonsRecord)
                .execute());
    }

    @Step("DB: Получение записи в таблице ppc.mod_reasons, id: {0}")
    public ModReasonsRecord getModReason(Long id) {
        return exec(db -> db.selectFrom(MOD_REASONS)
                .where(MOD_REASONS.ID.eq(id))
                .fetchOne()
        );
    }

    @Step("DB: Обновление записи в таблице ppc.mod_reasons")
    public void updateModReasons(ModReasonsRecord modReasonsRecord) {
        run(db -> db.update(MOD_REASONS)
                .set(modReasonsRecord)
                .where(MOD_REASONS.ID.eq(modReasonsRecord.getId()))
                .execute()
        );
    }

}
