package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;

import ru.yandex.autotests.direct.db.beans.modcmd.ModCmd;
import ru.yandex.autotests.direct.db.beans.modcmd.ModCmdRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModMailCandidatesStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModObjectVersionObjType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatussending;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AutoModerateRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModExportQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModMailCandidatesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModObjectVersionRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModReasonsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModResyncQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModerationCmdQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PostModerateRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PreModerateBannersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static java.time.Instant.now;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.AUTO_MODERATE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MODERATION_CMD_QUEUE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_EXPORT_QUEUE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_MAIL_CANDIDATES;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_OBJECT_VERSION;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_REASONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_RESYNC_QUEUE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.POST_MODERATE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.PRE_MODERATE_BANNERS;

/**
 * Created by buhter on 11.07.16.
 */

public class ModerationSteps extends BasePpcSteps {

    @Step("DB: получение записи из ppc.mod_export_queue для cid = {0}")
    public ModExportQueueRecord getModExportQueueRecord(Long cid) {
        return exec(db -> db.selectFrom(MOD_EXPORT_QUEUE)
                .where(MOD_EXPORT_QUEUE.CID.eq(cid))
                .fetchOne());
    }

    @Step("DB: получение записи из ppc.mod_object_version для type = {0}, id = {1}")
    public ModObjectVersionRecord getModObjectVersionRecord(ModObjectVersionObjType type, Long id) {
        return exec(db -> db.selectFrom(MOD_OBJECT_VERSION)
                .where(MOD_OBJECT_VERSION.OBJ_TYPE.eq(type)).and((MOD_OBJECT_VERSION.OBJ_ID.eq(id)))
                .fetchOne());
    }

    @Step("DB: добавление записи в ppc.mod_object_version для id = {0}, type = {1}, version = {2}")
    public void createModObjectVersionRecord(ModObjectVersionObjType type, Long id, String exportVersion) {
        exec(db -> db.insertInto(MOD_OBJECT_VERSION)
                .set(new ModObjectVersionRecord()
                        .setUpdateTime(Timestamp.from(now()))
                        .setExportVersion(exportVersion)
                        .setObjId(id)
                        .setObjType(type)
                )
                .execute());
    }

    @Step("DB: добавление записи в ppc.mod_reasons")
    public void createModReasonsRecord(Long id, BigInteger reasonId, Long campaignId, Long clientId,
            String reason, ModReasonsStatusmoderate statusModerate,
            ModReasonsStatuspostmoderate statusPostModerate,
            ModReasonsStatussending statusSending,
            ModReasonsType type)
    {
        exec(db -> db.insertInto(MOD_REASONS)
                .set(new ModReasonsRecord()
                        .setId(id)
                        .setRid(reasonId)
                        .setCid(campaignId)
                        .setClientid(clientId)
                        .setReason(reason)
                        .setStatusmoderate(statusModerate)
                        .setStatuspostmoderate(statusPostModerate)
                        .setStatussending(statusSending)
                        .setType(type)
                        .setTimecreated(Timestamp.from(now()))));
    }

    @Step("DB: получение записи из ppc.mod_reasons для id = {0}, type = {1}")
    public ModReasonsRecord getModReasonsRecord(Long id, ModReasonsType type) {
        return exec(db -> db.selectFrom(MOD_REASONS)
                .where(MOD_REASONS.ID.eq(id).and(MOD_REASONS.TYPE.eq(type)))
                .fetchOne());
    }

    @Step("DB: добавление записи в ppc.moderation_cmd_queue с cid = {0}, cmd = {1}, data = {2}")
    public void createModCmdRecord(Long cid, String cmd, String data) {
        exec(db -> db.insertInto(MODERATION_CMD_QUEUE)
                .set(new ModerationCmdQueueRecord()
                        .setCid(cid)
                        .setCmd(cmd)
                        .setData(data)
                        .setLogtime(Timestamp.valueOf(LocalDateTime.now()))
                )
                .execute());
    }

    @Step("DB: удаление записи из ppc.mod_object_version для type = {0}, id = {1}")
    public void deleteModObjectVersion(ModObjectVersionObjType type, Long id) {
        run(db -> db.deleteFrom(MOD_OBJECT_VERSION)
                .where(MOD_OBJECT_VERSION.OBJ_TYPE.eq(type))
                .and((MOD_OBJECT_VERSION.OBJ_ID.eq(id)))
                .execute()
        );
    }

    @Step("DB: получение записи из таблицы ppc.mod_resync_queue objectId = {0}")
    public List<ModResyncQueueRecord> getModResyncQueueRecord(Long objectId) {
        return exec(db -> db.selectFrom(MOD_RESYNC_QUEUE)
                .where(MOD_RESYNC_QUEUE.OBJECT_ID.eq(BigInteger.valueOf(objectId)))
                .fetch());
    }

    @Step("DB: получение записи из таблицы ppc.moderation_cmd_queue cmd = {0}, cid = {1}")
    public <T> ModCmdRecord<T> getModCmdRecord(ModCmd<T> cmd, Long cid) {
        ModerationCmdQueueRecord r = exec(db -> db.selectFrom(MODERATION_CMD_QUEUE)
                .where(MODERATION_CMD_QUEUE.CID.eq(cid))
                .and(MODERATION_CMD_QUEUE.CMD.eq(cmd.cmd))
                .fetchOne());
        if (r == null) {
            return null;
        }

        return ModCmdRecord.fromJooqRecord(r, cmd);
    }

    @Step("DB: получение записей из таблицы ppc.moderation_cmd_queue cid = {0}")
    public List<ModerationCmdQueueRecord> getModerationCmdQueueRecords(Long cid) {
        return exec(db -> db.selectFrom(MODERATION_CMD_QUEUE)
                .where(MODERATION_CMD_QUEUE.CID.eq(cid))
                .fetch());
    }

    @Step("DB: получение записей из таблицы ppc.moderation_cmd_queue cid = {0}, cmd = {0}")
    public List<ModerationCmdQueueRecord> getModerationCmdQueueRecords(Long cid, String cmd) {
        return exec(db -> db.selectFrom(MODERATION_CMD_QUEUE)
                .where(MODERATION_CMD_QUEUE.CID.eq(cid))
                .and(MODERATION_CMD_QUEUE.CMD.eq(cmd))
                .fetch());
    }

    @Step("DB: добавление баннера в ppc.auto_moderate с bid = {0}")
    public void addBannerToAutoModerateTable(Long bid) {
        exec(db -> db.insertInto(AUTO_MODERATE)
                .set(AUTO_MODERATE.BID, bid)
                .execute());
    }

    @Step("DB: получение записи из таблицы ppc.auto_moderate с bid = {0}")
    public AutoModerateRecord getAutoModerateRecord(Long bid) {
        return exec(db -> db.selectFrom(AUTO_MODERATE)
                .where(AUTO_MODERATE.BID.eq(bid))
                .fetchOne());
    }

    @Step("DB: добавление баннера в ppc.pre_moderate_banners с bid = {0}")
    public void addBannerToPreModerateBannersTable(Long bid) {
        exec(db -> db.insertInto(PRE_MODERATE_BANNERS)
                .set(PRE_MODERATE_BANNERS.BID, bid)
                .execute());
    }

    @Step("DB: получение записи из таблицы ppc.pre_moderate_banners с bid = {0}")
    public PreModerateBannersRecord getPreModerateBannersRecord(Long bid) {
        return exec(db -> db.selectFrom(PRE_MODERATE_BANNERS)
                .where(PRE_MODERATE_BANNERS.BID.eq(bid))
                .fetchOne());
    }

    @Step("DB: получение записи из таблицы ppc.post_moderate с bid = {0}")
    public PostModerateRecord getPostModerateRecord(Long bid) {
        return exec(db -> db.selectFrom(POST_MODERATE)
                .where(POST_MODERATE.BID.eq(bid))
                .fetchOne());
    }
}
