package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsMulticurrencySumsRecord;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampaignsMulticurrencySums.CAMPAIGNS_MULTICURRENCY_SUMS;


public class MulticurrencySteps  extends BasePpcSteps {
    @Step("DB: Получение мультивалютных данных для кампании {0}")
    public CampaignsMulticurrencySumsRecord getCampSumsForCid(long cid) {
        return exec(db -> db.selectFrom(CAMPAIGNS_MULTICURRENCY_SUMS)
                .where(CAMPAIGNS_MULTICURRENCY_SUMS.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: обновление мультивалютных данных")
    public void updateCampSumsForCid(CampaignsMulticurrencySumsRecord campSums) {
        run(db -> db.update(CAMPAIGNS_MULTICURRENCY_SUMS)
                .set(campSums)
                .where(CAMPAIGNS_MULTICURRENCY_SUMS.CID.eq(campSums.getCid()))
                .execute()
        );
    }
}
