package ru.yandex.autotests.direct.db.steps;

import javax.annotation.ParametersAreNonnullByDefault;

import com.github.shyiko.mysql.binlog.GtidSet;
import org.jooq.Field;
import org.jooq.impl.DSL;

import ru.yandex.autotests.direct.db.beans.mysql.ServerUuidAndGtidExecutedContainer;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

@ParametersAreNonnullByDefault
public class MysqlStateSteps extends BasePpcSteps {
    private static final Field<String> SERVER_UUID_FIELD = DSL.field("@@SERVER_UUID", String.class);
    private static final Field<String> GTID_EXECUTED_FIELD = DSL.field("@@GLOBAL.GTID_EXECUTED", String.class);

    @Step("DB: получение текущего gtid_set для базы")
    public String getCurrentServerGtidSet() {
        ServerUuidAndGtidExecutedContainer container = getGtidExecuted();

        GtidSet gtidSet = new GtidSet(container.getGtidExecuted());
        GtidSet.UUIDSet uuidSet = gtidSet.getUUIDSet(container.getServerUuid());
        return uuidSet.toString();
    }

    /**
     * Возвращает идентификатор mysql сервера и @@GLOBAL.GTID_EXECUTED
     * GTID_EXECUTED нужен, чтобы получить текущий GTID(global transaction identifier) для базы
     */
    private ServerUuidAndGtidExecutedContainer getGtidExecuted() {
        return exec(db -> db.select(SERVER_UUID_FIELD, GTID_EXECUTED_FIELD)
                .fetchOne(r -> new ServerUuidAndGtidExecutedContainer()
                        .withServerUuid(r.get(SERVER_UUID_FIELD))
                        .withGtidExecuted(r.get(GTID_EXECUTED_FIELD))
                ));
    }

}
