package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import org.jooq.Result;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.OptimizingCampaignRequestsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.OPTIMIZING_CAMPAIGN_REQUESTS;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class OptimizingCampaignRequestsSteps extends BasePpcSteps {
    @Step("DB: получение записей из таблицы ppc.optimizing_campaign_requests (cid = {0})")
    public List<OptimizingCampaignRequestsRecord> getOptimizingCampaignRequests(Long cid) {
        Result<OptimizingCampaignRequestsRecord> records = exec(db -> db.selectFrom(OPTIMIZING_CAMPAIGN_REQUESTS)
                .where(OPTIMIZING_CAMPAIGN_REQUESTS.CID.eq(cid))
                .fetch());
        String logRecord = records == null ? "null" : records.formatJSON();
        getLogger().info("Получены записи из таблицы ppc.optimizing_campaign_requests: " + logRecord);
        addJsonAttachment("Получены записи", logRecord);
        return records;
    }
}
