package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Organizations.ORGANIZATIONS;

public class OrganizationsSteps extends BasePpcSteps {

    @Step("DB: Создание записи с тестовыми данными в таблице ppc.organizations, если её ещё нет. (ClientID = {0}, permalink_id = {1})")
    public void createFakeClientOrganization(long clientId, long permalinkId) {
        exec(db -> db.insertInto(ORGANIZATIONS)
                .columns(ORGANIZATIONS.CLIENTID, ORGANIZATIONS.PERMALINK_ID)
                .values(clientId, permalinkId)
                .onDuplicateKeyIgnore()
                .execute()
        );
    }
}
