package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsAuctionStatRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BsAuctionStat.BS_AUCTION_STAT;

public class PhrasesStatSteps extends BasePpcSteps {

    @Step("DB: вставка записи в таблицу ppc.bs_auction_stat")
    public void saveBsAuctionStatRecord(BsAuctionStatRecord bsAuctionStatRecord) {
        run(db ->
                db.insertInto(BS_AUCTION_STAT)
                        .set(bsAuctionStatRecord)
                        .execute());
    }

    @Step("DB: Получение записи из таблицы ppc.bs_auction_stat groupId:{0} phraseId:{1}")
    public BsAuctionStatRecord getStatRecord(Long groupId, BigInteger phraseId) {
        return exec(db ->
                db.selectFrom(BS_AUCTION_STAT)
                        .where(BS_AUCTION_STAT.PID.eq(groupId)
                                .and(BS_AUCTION_STAT.PHRASEID.eq(phraseId)))
                        .fetchOne());
    }
}
