package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerPixelsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerPixels.BANNER_PIXELS;

/*
 * Работа с пикселями (счётчиками показов).
 */
public class PixelsSteps extends BasePpcSteps {

    public static String replaceRandomMacrosForBS(String pixel) {
        return pixel.replaceAll("(%(25)?)((?i)(aw_)?random)(%(25)?)", "\\{DRND\\}");
    }

    @Step("DB: создание записи в таблице ppc.banner_pixels")
    public void saveBannerPixels(BannerPixelsRecord bannerPixelsRecord) {
        run(db -> db.insertInto(BANNER_PIXELS)
                .set(bannerPixelsRecord)
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.banner_pixels bid:{0}, pixel_id: {1}, pixel_url: {2}")
    public void saveBannerPixels(Long bid, Long pixelId, String pixelUrl) {
        saveBannerPixels(new BannerPixelsRecord()
                .setBid(bid)
                .setPixelId(pixelId)
                .setPixelUrl(pixelUrl)
        );
    }

    public Long createAndSaveNewPixelForBanner(Long bid, String url) {
        Long pixelId = autoIncSteps().getNewPixelId();
        saveBannerPixels(bid, pixelId, url);
        return pixelId;
    }

    @Step("DB: получение списка записей ppc.banner_pixels для баннера (bid = {0}")
    public List<BannerPixelsRecord> getBannerPixelsByBid(long bid) {
        return exec(db ->
                db.selectFrom(BANNER_PIXELS)
                        .where(BANNER_PIXELS.BID.eq(bid))
                        .fetch());
    }
}
