package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.Placements;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class PlacementsSteps extends BasePpcDictSteps {

    @Step("DB: Привязка сделки {0} к кампании {1}")
    public void addPlacement(Long pageId, Integer isYandexPage) {
        exec(db -> db.insertInto(Placements.PLACEMENTS)
                .set(Placements.PLACEMENTS.PAGEID, pageId)
                .set(Placements.PLACEMENTS.DOMAIN, "")
                .onDuplicateKeyUpdate()
                .set(Placements.PLACEMENTS.IS_YANDEX_PAGE, isYandexPage)
                .execute());
    }
}
