package ru.yandex.autotests.direct.db.steps;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.PpcPropertiesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.PpcProperties.PPC_PROPERTIES;

public class PpcPropertiesSteps extends BasePpcDictSteps {
    private static final DateTimeFormatter CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY_SHARD_FORMATTER =
            DateTimeFormatter.ISO_LOCAL_DATE_TIME
                    .withZone(ZoneId.of("Europe/Moscow"));

    public static final String UPDATE_PERF_COUNTERS_NAME = "update_perf_counters";
    public static final String GEO_REGIONS_UPDATE_TIME = "geo_regions_update_time";
    public static final String GEO_TIMEZONES_UPDATE_TIME = "geo_timezones_update_time";
    //https://st.yandex-team.ru/DIRECT-53323  Мониторинг доменов от БК
    public static final String BS_URL_AVAILABILITIY_REQ_ID = "bs_url_availability_req_id";
    public static final String BS_URL_AVAILABILITIY_USAGE_PCT = "url_availability_bs_usage_pct";
    //https://st.yandex-team.ru/DIRECT-56895 Скрипт полного реэкспорта данных в LogBroker
    public static final String MAX_FULL_LB_EXPORT_CAMPAIGNS_IN_QUEUE = "MAX_FULL_LB_EXPORT_CAMPAIGNS_IN_QUEUE";
    public static final String FULL_LB_EXPORT_MAX_CHUNK_PER_ITERATION = "FULL_LB_EXPORT_MAX_CHUNK_PER_ITERATION";
    public static final String FULL_LB_EXPORT_LAST_PROCESSED_CID_SHARD = "FULL_LB_EXPORT_LAST_PROCESSED_CID_SHARD_";

    private static final String CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY_SHARD_NAME =
            "camp_aggregated_lastchange_high_boundary_shard_";

    @Step("DB: удаление записей об успшном выполнении скрипта" + UPDATE_PERF_COUNTERS_NAME
            + " в ppcdict.ppc_properties")
    public void deleteUpdatePerfCountersScriptSuccess() {
        run(db ->
                db.deleteFrom(PPC_PROPERTIES)
                        .where(PPC_PROPERTIES.NAME.contains(UPDATE_PERF_COUNTERS_NAME))
                        .execute());
    }

    @Deprecated
    @Step("DB: получение записи об успешном выполнении скрипта" + UPDATE_PERF_COUNTERS_NAME
            + " в ppcdict.ppc_properties")
    public String getUpdatePerfCountersScriptSuccess() {
        return exec(db ->
                db.selectFrom(PPC_PROPERTIES)
                        .where(PPC_PROPERTIES.NAME.contains(UPDATE_PERF_COUNTERS_NAME))
                        .fetchOne()
                        .getValue());
    }

    @Step("DB: получаем значение из ppcdict.ppc_properties для name = {0}, значение по-умолчанию {1}")
    public String getPropertyValue(String propertyName, String defaultValue) {
        return exec(db ->
                db.selectFrom(PPC_PROPERTIES)
                        .where(PPC_PROPERTIES.NAME.contains(propertyName))
                        .fetchOptional()
                        .orElse(createPpcPropertiesRecord(propertyName, defaultValue))
                        .getValue(PPC_PROPERTIES.VALUE));
    }

    public String getPropertyValue(String propertyName) {
        return getPropertyValue(propertyName, null);
    }

    @Step("DB: добавление/обновление записи в ppcdict.ppc_properties. name = {0}, value = {1}")
    public void insertPropertyValue(String propertyName, String propertyValue) {
        run(db -> db.insertInto(PPC_PROPERTIES, PPC_PROPERTIES.NAME, PPC_PROPERTIES.VALUE)
                .values(propertyName, propertyValue)
                .onDuplicateKeyUpdate()
                .set(PPC_PROPERTIES.VALUE, propertyValue)
                .execute());
    }

    @Step("DB: обновляем значение из ppcdict.ppc_properties для name = {0}")
    public void updatePropertyValue(String propertyName, String propertyValue) {
        run(db -> db.update(PPC_PROPERTIES)
                .set(createPpcPropertiesRecord(propertyName, propertyValue))
                .where(PPC_PROPERTIES.NAME.eq(propertyName))
                .execute());
    }

    public ZonedDateTime getCampAggregatedLastChangeHighBoundary(int shard) {
        String lastChange = exec(db -> db.select(PPC_PROPERTIES.VALUE)
                .from(PPC_PROPERTIES)
                .where(PPC_PROPERTIES.NAME.eq(CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY_SHARD_NAME + shard))
                .fetchOptional(PPC_PROPERTIES.VALUE)
                .get());
        return ZonedDateTime.parse(lastChange, CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY_SHARD_FORMATTER);
    }

    private static PpcPropertiesRecord createPpcPropertiesRecord(String propertyName, String propertyValue) {
        return new PpcPropertiesRecord()
                .setName(propertyName)
                .setValue(propertyValue);
    }

}
