package ru.yandex.autotests.direct.db.steps;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.CpmPricePackagesStatusApprove;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.CpmPricePackagesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.CpmPricePackages.CPM_PRICE_PACKAGES;

public class PricePackagesSteps extends BasePpcDictSteps {
    @Step
    public CpmPricePackagesRecord getCpmPricePackagesRecordById(Long packageId) {
        return exec(db -> db.selectFrom(CPM_PRICE_PACKAGES)
                .where(CPM_PRICE_PACKAGES.PACKAGE_ID.eq(packageId))
                .fetchOne()
        );
    }

    @Step("DB: сохранение статусов прайсовой кампании packageRecord={0}")
    public Long setCpmPricePackages(CpmPricePackagesRecord packageRecord) {
        return exec(db -> { db.insertInto(CPM_PRICE_PACKAGES)
                .set(CPM_PRICE_PACKAGES.TITLE, nvl(packageRecord.getTitle(), "Прайсовый пакет для автотестов"))
                .set(CPM_PRICE_PACKAGES.TRACKER_URL,
                        nvl(packageRecord.getTrackerUrl(), "http://st.yandex-team.ru/DIRECT-123"))
                .set(CPM_PRICE_PACKAGES.PRICE, nvl(packageRecord.getPrice(), BigDecimal.TEN))
                .set(CPM_PRICE_PACKAGES.ORDER_VOLUME_MIN,  nvl(packageRecord.getOrderVolumeMin(), 1L))
                .set(CPM_PRICE_PACKAGES.ORDER_VOLUME_MAX, nvl(packageRecord.getOrderVolumeMax(), 5L))
                .set(CPM_PRICE_PACKAGES.PRICE_MARKUPS, packageRecord.getPriceMarkups())
                .set(CPM_PRICE_PACKAGES.TARGETING_MARKUPS, packageRecord.getTargetingMarkups())
                .set(CPM_PRICE_PACKAGES.TARGETINGS_FIXED, nvl(packageRecord.getTargetingsFixed(), "{}"))
                .set(CPM_PRICE_PACKAGES.TARGETINGS_CUSTOM, nvl(packageRecord.getTargetingsCustom(), "{}"))
                .set(CPM_PRICE_PACKAGES.STATUS_APPROVE,
                        nvl(packageRecord.getStatusApprove(), CpmPricePackagesStatusApprove.Yes))
                .set(CPM_PRICE_PACKAGES.DATE_START, nvl(packageRecord.getDateStart(), Date.valueOf(LocalDate.now())))
                .set(CPM_PRICE_PACKAGES.DATE_END, nvl(packageRecord.getDateStart(), Date.valueOf(LocalDate.now().plusDays(7))))
                .set(CPM_PRICE_PACKAGES.AVAILABLE_AD_GROUP_TYPES, nvl(packageRecord.getAvailableAdGroupTypes(), "cpm_yndx_frontpage"))
                .set(CPM_PRICE_PACKAGES.IS_CPD, nvl(packageRecord.getIsCpd(), 0))
                .execute();
                return db.lastID().longValue();
            }
        );
    }

    @Step("DB: Обновление записи в таблице cpm_price_packages")
    public void updateCampaignCpmPrice(CpmPricePackagesRecord packageRecord) {
        run(db -> db.update(CPM_PRICE_PACKAGES)
                .set(packageRecord)
                .where(CPM_PRICE_PACKAGES.PACKAGE_ID.eq(packageRecord.getPackageId()))
                .execute()
        );
    }

    @Step("DB: Удаление записи в таблице cpm_price_packages")
    public void deleteCampaignCpmPrice(Long packageId) {
        run(db -> db.delete(CPM_PRICE_PACKAGES)
                .where(CPM_PRICE_PACKAGES.PACKAGE_ID.eq(packageId))
                .execute()
        );
    }

    public static <T> T nvl(@Nullable T first, @Nonnull T second) {
        return first != null ? first : Objects.requireNonNull(second);
    }

}
