package ru.yandex.autotests.direct.db.steps;

import java.math.BigDecimal;
import java.util.Map;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.ProductsType;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.Products.PRODUCTS;

public class ProductsSteps extends BasePpcDictSteps {
    public Map<Long, ProductsType> getAllProductTypesById() {
        return exec(db -> db.select(PRODUCTS.PRODUCTID, PRODUCTS.TYPE)
                .from(PRODUCTS)
                .where(PRODUCTS.PRICE.isNotNull()).and(PRODUCTS.TYPE.ne(ProductsType.geo))
                .fetchMap(PRODUCTS.PRODUCTID, PRODUCTS.TYPE)
        );
    }

    public BigDecimal getProductPrice(Long productId) {
        return exec(db -> db.select(PRODUCTS.PRICE)
                .from(PRODUCTS)
                .where(PRODUCTS.PRODUCTID.eq(productId))
                .fetchOne()
                .get(PRODUCTS.PRICE)
        );
    }
}
