package ru.yandex.autotests.direct.db.steps;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingMultiplierValuesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BIDS_PERFORMANCE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BIDS_RETARGETING;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.RETARGETING_CONDITIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.RETARGETING_MULTIPLIER_VALUES;


public class RetargetingConditionSteps extends BasePpcSteps {
    @Step("DB: получение записей из ppc.retargeting_conditions для id = {0}")
    public List<RetargetingConditionsRecord> getRetargetingConditionsByClient(Long clientId) {
        return exec(db -> db.selectFrom(RETARGETING_CONDITIONS)
                .where(RETARGETING_CONDITIONS.CLIENTID.eq(clientId))
                .fetch());
    }

    @Step("DB: получение неудаленных записей из ppc.retargeting_conditions для id = {0}")
    public List<RetargetingConditionsRecord> getUndeletedRetargetingConditionsByClient(Long clientId) {
        return exec(db -> db.selectFrom(RETARGETING_CONDITIONS)
                .where(RETARGETING_CONDITIONS.CLIENTID.eq(clientId)).and(RETARGETING_CONDITIONS.IS_DELETED.eq(0))
                .fetch());
    }

    @Step("DB: получение записи из ppc.retargeting_conditions для id = {0}")
    public RetargetingConditionsRecord getRetargeingConditionByRetCondId(Long retCondId) {
        return exec(db -> db.selectFrom(RETARGETING_CONDITIONS)
                .where(RETARGETING_CONDITIONS.RET_COND_ID.eq(retCondId))
                .fetchOne()
        );
    }

    @Step("DB: удаление всех неиспользуемых ретаргетингов из ppc.retargeting_conditions для clientId = {0}")
    public void deleteUnusedRetargetingsConditions(Long clientID) {
        List<Long> clientRetCondIds = this.getUndeletedRetargetingConditionsByClient(Long.valueOf(clientID)).stream()
                .map(RetargetingConditionsRecord::getRetCondId)
                .collect(Collectors.toList());

        List<Long> usedRetCondIds = exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.RET_COND_ID.in(clientRetCondIds)).fetch())
                .stream()
                .map(BidsRetargetingRecord::getRetCondId)
                .collect(Collectors.toList());

        List<Long> usedInMultiplierValuesRetCondIds = exec(db -> db.selectFrom(RETARGETING_MULTIPLIER_VALUES)
                .where(RETARGETING_MULTIPLIER_VALUES.RET_COND_ID.in(clientRetCondIds))
                .fetch())
                .stream()
                .map(RetargetingMultiplierValuesRecord::getRetCondId)
                .collect(Collectors.toList());

        clientRetCondIds.removeAll(usedRetCondIds);
        clientRetCondIds.removeAll(usedInMultiplierValuesRetCondIds);

        // Remove all relatives items from BIDS_PERFORMANCE table
        run(db -> db.delete(BIDS_PERFORMANCE)
                .where(BIDS_PERFORMANCE.RET_COND_ID.in(clientRetCondIds))
                .execute());
        run(db ->
                db.delete(RETARGETING_CONDITIONS)
                        .where(RETARGETING_CONDITIONS.RET_COND_ID.in(clientRetCondIds))
                        .execute()
        );
    }

    @Step("DB: добавление записи в ppc.retargeting_conditions")
    public Long addRetargetingCondition(RetargetingConditionsRecord record, Long clientId) {
        Long conditionId = autoIncSteps().getNewRetargetingConditionId(clientId);
        record.setRetCondId(conditionId);
        exec(db -> db.insertInto(RETARGETING_CONDITIONS)
                .set(record)
                .execute()
        );
        return conditionId;
    }

    @Step("DB: удаление записи из ppc.retargeting_conditions id = {0}")
    public void deleteRetargeingCondition(Long retCondId) {
        run(db -> db.deleteFrom(RETARGETING_CONDITIONS)
                .where(RETARGETING_CONDITIONS.RET_COND_ID.eq(retCondId))
                .execute()
        );
    }

    @Step("DB: удаление записи из ppc.retargeting_conditions type = {0}")
    public void deleteRetargeingCondition(RetargetingConditionsRetargetingConditionsType retCondType, Long clientId) {
        run(db -> db.deleteFrom(RETARGETING_CONDITIONS)
                .where(RETARGETING_CONDITIONS.RETARGETING_CONDITIONS_TYPE.eq(retCondType)
                        .and(RETARGETING_CONDITIONS.CLIENTID.eq(clientId)))
                .execute()
        );
    }

    @Step("DB: изменение записи в ppc.retargeting_conditions")
    public void updateRetargetingCondition(RetargetingConditionsRecord record) {
        exec(db -> db.update(RETARGETING_CONDITIONS)
                .set(record)
                .where(RETARGETING_CONDITIONS.RET_COND_ID.eq(record.getRetCondId()))
                .execute()
        );
    }
}
