package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModReasonsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MOD_REASONS;

public class ShowDiagSteps extends BasePpcSteps {
    private static final String SOME_MOD_REASON = "---\n-\n  id: 333";

    @Step("DB: добавление записи в ppc.mod_reasons для id = {1}, type = {0}, reason = {2}")
    public void createModReasonsRecord(ModReasonsType type, Long id, String reason) {
        exec(db -> db.insertInto(MOD_REASONS)
                .set(new ModReasonsRecord()
                        .setId(id)
                        .setType(type)
                        .setReason(reason)
                )
                .execute());
    }

    /**
     * можно использовать, если нужно сделать каку-то причину отклонения, и не важно какую
     */
    public void createSomeModReasonsRecord(ModReasonsType type, Long id) {
        createModReasonsRecord(type, id, SOME_MOD_REASON);
    }
}
