package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.SitelinksLinksRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.SitelinksSetToLinkRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.SitelinksLinks.SITELINKS_LINKS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.SitelinksSetToLink.SITELINKS_SET_TO_LINK;

/**
 * Created by buhter on 07/11/2016.
 */
public class SitelinksSteps extends BasePpcSteps {

    @Step("DB: получение записей из ppc.sitelinks_links для sitelinkSetId = {0}")
    public List<SitelinksLinksRecord> getSitelinksBySetId(Long sitelinkSetId) {
        Long[] slIds = getSitelinksSetToLinksBySetId(sitelinkSetId).stream()
                .map(SitelinksSetToLinkRecord::getSlId).toArray(Long[]::new);

        return exec(db -> db.selectFrom(SITELINKS_LINKS)
                .where(SITELINKS_LINKS.SL_ID.in(slIds))
                .fetch());
    }

    @Step("DB: получение записей из ppc.sitelinks_set_to_link для sitelinkSetId = {0}")
    public List<SitelinksSetToLinkRecord> getSitelinksSetToLinksBySetId(Long sitelinkSetId) {
        return exec(db -> db.selectFrom(SITELINKS_SET_TO_LINK)
                .where(SITELINKS_SET_TO_LINK.SITELINKS_SET_ID.eq(sitelinkSetId))
                .fetch());
    }

    @Step("DB: удаление записей из ppc.sitelinks_set_to_link для sitelinkSetId = {0}")
    public void deleteSitelinksSetToLinksBySetId(Long sitelinkSetId) {
        exec(db -> db.deleteFrom(SITELINKS_SET_TO_LINK)
                    .where(SITELINKS_SET_TO_LINK.SITELINKS_SET_ID.eq(sitelinkSetId))
                    .execute());
    }

    @Step("DB: установка в ppc.sitelinks_links tl_id = {1}, href = '' для sitelinkId = {0}")
    public void setDesktopLandingForSitelink(Long sitelinkId, Long turbolandingId) {
        run(db -> db.update(SITELINKS_LINKS)
                .set(SITELINKS_LINKS.HREF, "")
                .set(SITELINKS_LINKS.TL_ID, turbolandingId)
                .where(SITELINKS_LINKS.SL_ID.eq(sitelinkId))
                .execute()
        );
    }

}
