package ru.yandex.autotests.direct.db.steps;

import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Users;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AdditionsItemCallouts.ADDITIONS_ITEM_CALLOUTS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannersAdditions.BANNERS_ADDITIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Users.USERS;

/*
* todo javadoc
*/
public class SomeSteps extends BasePpcSteps {

    @Step
    public void getUserFromShard() {
        List<UsersRecord> rec = exec(
                db -> db.selectFrom(Users.USERS)
                        .where(Users.USERS.LOGIN.eq("kuhtich"))
                        .fetch());
        System.out.println(rec);
    }

    @Step
    public void updateUser() {
        run(db-> {
            db.update(USERS)
                    .set(USERS.EMAIL, "kuhtich@gmail.com")
                    .where(USERS.LOGIN.eq("Kuhtich"))
                    .execute();

            String a = db.select(USERS.EMAIL)
                    .from(USERS)
                    .where(USERS.LOGIN.eq("Kuhtich"))
                    .fetchOne(USERS.EMAIL);

            System.out.println("Result: " + a);
        });
    }

    @Step
    public void callouts(int shard) {
        run(db-> {
            List<Long> lst = Collections.singletonList(277684395L);
            Long clientID = 2283785L;

            db.transaction(conf -> {
                        DSL.using(conf).deleteFrom(BANNERS_ADDITIONS)
                                .where(BANNERS_ADDITIONS.BID.in(lst))
                                .execute();
                        DSL.using(conf).deleteFrom(ADDITIONS_ITEM_CALLOUTS)
                        .where(ADDITIONS_ITEM_CALLOUTS.CLIENTID.eq(clientID))
                        .execute();
                    }
            );

            db.insertInto(ADDITIONS_ITEM_CALLOUTS)
                    .set(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID, 878L)
                    .set(ADDITIONS_ITEM_CALLOUTS.CALLOUT_TEXT, "CALLOUT_TEXT")
                    .set(ADDITIONS_ITEM_CALLOUTS.CLIENTID, clientID)
                    .set(ADDITIONS_ITEM_CALLOUTS.FLAGS, "FLAGS")
                    .set(ADDITIONS_ITEM_CALLOUTS.HASH, BigInteger.valueOf(1245L))
                    .set(ADDITIONS_ITEM_CALLOUTS.STATUSMODERATE, AdditionsItemCalloutsStatusmoderate.Yes)
                    .execute();


            db.insertInto(ADDITIONS_ITEM_CALLOUTS)
                    .set(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID, 879L)
                    .set(ADDITIONS_ITEM_CALLOUTS.CALLOUT_TEXT, "CALLOUT_TEXT")
                    .set(ADDITIONS_ITEM_CALLOUTS.CLIENTID, clientID)
                    .set(ADDITIONS_ITEM_CALLOUTS.FLAGS, "FLAGS")
                    .set(ADDITIONS_ITEM_CALLOUTS.HASH, BigInteger.valueOf(12456))
                    .set(ADDITIONS_ITEM_CALLOUTS.STATUSMODERATE, AdditionsItemCalloutsStatusmoderate.Yes)
                    .execute();

            db.insertInto(BANNERS_ADDITIONS)
                    .set(BANNERS_ADDITIONS.BID, lst.get(0))
                    .set(BANNERS_ADDITIONS.ADDITIONS_ITEM_ID, 878L)
                    .set(BANNERS_ADDITIONS.ADDITIONS_TYPE, BannersAdditionsAdditionsType.callout)
                    .execute();

            db.insertInto(BANNERS_ADDITIONS)
                    .set(BANNERS_ADDITIONS.BID, lst.get(0))
                    .set(BANNERS_ADDITIONS.ADDITIONS_ITEM_ID, 879L)
                    .set(BANNERS_ADDITIONS.ADDITIONS_TYPE, BannersAdditionsAdditionsType.callout)
                    .execute();


            Result<Record> bannerAdditions = db.select()
                    .from(BANNERS_ADDITIONS)
                    .join(ADDITIONS_ITEM_CALLOUTS)
                    .on(BANNERS_ADDITIONS.ADDITIONS_ITEM_ID.eq(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID))
                    .where(BANNERS_ADDITIONS.BID.in(lst))
                    .and(ADDITIONS_ITEM_CALLOUTS.STATUSMODERATE.eq(AdditionsItemCalloutsStatusmoderate.Yes))
                    .orderBy(BANNERS_ADDITIONS.BID, BANNERS_ADDITIONS.ADDITIONS_ITEM_ID)
                    .limit(0, 10)
                    .fetch();

            AdditionsItemCalloutsRecord additionsItemCalloutsRecord1 = bannerAdditions.get(0).into(ADDITIONS_ITEM_CALLOUTS);
            AdditionsItemCalloutsRecord additionsItemCalloutsRecord2 = bannerAdditions.get(1).into(ADDITIONS_ITEM_CALLOUTS);

            System.out.println(additionsItemCalloutsRecord1);
            System.out.println(additionsItemCalloutsRecord2);

            Result<AdditionsItemCalloutsRecord> calloutsByClientID = db
                    .selectFrom(ADDITIONS_ITEM_CALLOUTS)
                    .where(ADDITIONS_ITEM_CALLOUTS.CLIENTID.eq(clientID))
                    .fetch();

            System.out.println(calloutsByClientID);
        });
    }

}
