package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.SspPlatformsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.SspPlatforms.SSP_PLATFORMS;

/**
 * Created by pavryabov on 02.09.16.
 */
public class SspPlatformsSteps extends BasePpcDictSteps {

    @Step("DB: получаем запись из ppcdict.ssp_platforms для title = {0}")
    public SspPlatformsRecord getSspPlatformsRecordByTitle(String title) {
        return exec(db ->
                db.selectFrom(SSP_PLATFORMS)
                        .where(SSP_PLATFORMS.TITLE.eq(title))
                        .fetchOne()
        );
    }

    @Step("DB: запись в таблицу ppcdict.ssp_platforms новой записи с title = {0}")
    public void saveSspPlatforms(String title) {
        SspPlatformsRecord record = new SspPlatformsRecord();
        record.setTitle(title);
        exec(db -> db.insertInto(SSP_PLATFORMS)
                .set(record)
                .execute());
    }

    public void saveSspPlatformsIfNotExist(String title) {
        SspPlatformsRecord record = getSspPlatformsRecordByTitle(title);
        if (record == null) {
            saveSspPlatforms(title);
        }
    }
}
