package ru.yandex.autotests.direct.db.steps;

import java.time.LocalDateTime;

import ru.yandex.autotests.direct.db.steps.base.BasePpcLogSteps;

public class StrategyChangeLogSteps extends BasePpcLogSteps {
    public boolean isLogRecordExists(Long uid, Long campaignId) {
        LocalDateTime now = LocalDateTime.now();
        return exec(dslContext -> dslContext.fetch(
                String.format(
                        "select 1 from log_strategy_change_%4d%02d where uid = ? and cid = ?",
                        now.getYear(), now.getMonthValue()),
                uid, campaignId)
                .isNotEmpty());
    }
}
