package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.StrategyMetrikaCountersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.STRATEGY_METRIKA_COUNTERS;

@ParametersAreNonnullByDefault
public class StrategyMetrikaCountersSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.strategy_metrika_counters (strategy_id:{0}")
    public StrategyMetrikaCountersRecord getStrategyMetrikaCountersRecord(Long strategyId) {
        return exec(db -> db.selectFrom(STRATEGY_METRIKA_COUNTERS)
                .where(STRATEGY_METRIKA_COUNTERS.STRATEGY_ID.eq(strategyId))
                .fetchOne());
    }

    @Step("DB: получение записей из таблицы ppc.strategy_metrika_counters (strategy_id:{0}")
    public List<StrategyMetrikaCountersRecord> getStrategyMetrikaCountersRecords(Long strategyId) {
        return exec(db -> db.selectFrom(STRATEGY_METRIKA_COUNTERS)
                .where(STRATEGY_METRIKA_COUNTERS.STRATEGY_ID.eq(strategyId))
                .fetch());
    }
}
