package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.TargetingCategoriesTargetingType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.TargetingCategoriesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.TargetingCategories.TARGETING_CATEGORIES;

public class TargetingCategoriesSteps extends BasePpcDictSteps {
    @Step("DB: получение записи из targeting_categories по id {0}")
    public TargetingCategoriesRecord getTargetingCategoriesRecords(Long categoryId) {
        return exec(db -> db.selectFrom(TARGETING_CATEGORIES)
                .where(TARGETING_CATEGORIES.CATEGORY_ID.eq(categoryId))
                .fetchOne());
    }

    @Step("DB: получение записи из targeting_categories по id {0}")
    public List<TargetingCategoriesRecord> getTargetingCategoriesRecords() {
        return exec(db -> db.selectFrom(TARGETING_CATEGORIES).fetch());
    }

    @Step("DB:  новая запись в таблице targeting_categories")
    public void saveTargetingCategoriesRecords(TargetingCategoriesRecord targetingCategoriesRecord) {
        Long categotyId = autoIncSteps().getNewBannerCreativeId();
        exec(db -> db.insertInto(TARGETING_CATEGORIES)
                .set(targetingCategoriesRecord.setCategoryId(categotyId))
                .execute());
    }

    @Step("DB:  удаление записи в таблице targeting_categories по id {0}")
    public void deleteTargetingCategoriesRecords(Long... categoryIds) {
        exec(db -> db.delete(TARGETING_CATEGORIES)
                .where(TARGETING_CATEGORIES.CATEGORY_ID.in(categoryIds))
                .execute());
    }

    @Step("DB: получение записи из targeting_categories по targeting type {0} и import_id {1}")
    public TargetingCategoriesRecord getTargetingCategoriesRecord(TargetingCategoriesTargetingType targetingCategoriesTargetingType, Long
            importId) {
        return exec(db -> db.selectFrom(TARGETING_CATEGORIES).where(TARGETING_CATEGORIES.IMPORT_ID.eq(BigInteger.valueOf(importId)))
                .and(TARGETING_CATEGORIES.TARGETING_TYPE.eq(targetingCategoriesTargetingType))
                .fetchOne());
    }

    @Step("DB: сохранение для категории childCategoryId {0} новой родительской категории parentCategoryId {1}")
    public void saveParentCategoryIdforChild(Long childCategoryId, Long parentCategoryId) {
        exec(db -> db.update(TARGETING_CATEGORIES)
                .set(TARGETING_CATEGORIES.PARENT_CATEGORY_ID, parentCategoryId)
                .where(TARGETING_CATEGORIES.CATEGORY_ID.eq(childCategoryId))
                .execute());
    }
}
