package ru.yandex.autotests.direct.db.steps;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.TemplateResourceRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.TEMPLATE_RESOURCE;

@ParametersAreNonnullByDefault
public class TemplateResourceSteps extends BasePpcDictSteps {

    @Step("DB: получение записи из таблицы ppcdict.template_resource (id:{0})")
    public TemplateResourceRecord getTemplateResource(Long id) {
        return exec(db -> db.selectFrom(TEMPLATE_RESOURCE)
                .where(TEMPLATE_RESOURCE.ID.eq(id))
                .fetchOne());
    }

    @Step("DB: получение записей из таблицы ppcdict.template_resource (ids:{0})")
    public Map<Long, TemplateResourceRecord> getTemplateResourcesByIds(Collection<Long> ids) {
        return exec(db -> db.selectFrom(TEMPLATE_RESOURCE)
                .where(TEMPLATE_RESOURCE.ID.in(ids))
                .fetchMap(TEMPLATE_RESOURCE.ID));
    }

}
