package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampTurbolandingMetrikaCountersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_TURBOLANDING_METRIKA_COUNTERS;

public class TurbolandingsMetrikaCountersSteps extends BasePpcSteps {
    @Step("DB: Добавление записей в таблицу ppc.camp_turbolanding_metrika_counters")
    public void createCampTurbolandingsMetricaCounters(CampTurbolandingMetrikaCountersRecord record) {
        exec(db -> db.insertInto(CAMP_TURBOLANDING_METRIKA_COUNTERS)
                .set(record)
                .execute());
    }

    @Step("DB: Получение записей из таблицы ppc.camp_turbolanding_metrika_counters по banner ID = {0}")
    public List<CampTurbolandingMetrikaCountersRecord> getRecordByBid(Long bid) {
        return exec(db -> db.selectFrom(CAMP_TURBOLANDING_METRIKA_COUNTERS)
                .where(CAMP_TURBOLANDING_METRIKA_COUNTERS.BID.eq(bid))
                .fetch());
    }
}
