package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersApiOptionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.UsersApiOptions.USERS_API_OPTIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.PPC_PROPERTIES;

public class UsersApiOptionsSteps extends BasePpcSteps {

    @Step("DB: Oбновление записи в таблице ppc.user_options")
    public void updateUsersApiOptions(UsersApiOptionsRecord usersOptions) {
        run(db -> db.update(USERS_API_OPTIONS)
                .set(usersOptions)
                .where(USERS_API_OPTIONS.UID.eq(usersOptions.getUid()))
                .execute()
        );
    }

    @Step("DB: Получение записи в таблице ppc.user_options, uid: {0}")
    public UsersApiOptionsRecord getUsersApiOptions(Long uid) {
        return exec(db -> db.selectFrom(USERS_API_OPTIONS)
                .where(USERS_API_OPTIONS.UID.eq(uid))
                .fetchOne()
        );
    }

    @Step("DB: Установка или обновление api_units_daily в таблице ppc.user_options, uid: {0}, api_units_daily: {1}")
    public void setUserApiUnitsDailyLimit(Long uid, Long api_units_daily) {
        exec(db -> db.insertInto(USERS_API_OPTIONS, USERS_API_OPTIONS.UID, USERS_API_OPTIONS.API_UNITS_DAILY)
                .values(uid, api_units_daily)
                .onDuplicateKeyUpdate()
                .set(USERS_API_OPTIONS.API_UNITS_DAILY, api_units_daily)
                .execute()
        );
    }

    @Step("DB: Получение api_units_daily из таблицы ppc.user_options, uid: {0}")
    public Long getUserApiUnitsDailyLimit(Long uid) {
        UsersApiOptionsRecord usersOptions = getUsersApiOptions(uid);
        return usersOptions != null ? usersOptions.getApiUnitsDaily() : null;
    }

    @Step("DB: Задать список допустимых адресов \"{1}\" в ppc.user_api_options для uid: {0}")
    public void setAllowedIps(Long uid, String... allowedIps) {
        String joinedAllowedIps = String.join(", ", allowedIps);
        exec(db -> db.insertInto(USERS_API_OPTIONS, USERS_API_OPTIONS.UID, USERS_API_OPTIONS.API_ALLOWED_IPS)
                .values(uid, joinedAllowedIps)
                .onDuplicateKeyUpdate()
                .set(USERS_API_OPTIONS.API_ALLOWED_IPS, joinedAllowedIps)
                .execute());
    }
}
