package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.beans.UserOptionsModel.UserOptionsModel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersOptionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.direct.db.steps.base.DirectDbStepsException;
import ru.yandex.autotests.direct.utils.beans.NullAwareBeanUtilsBean;
import ru.yandex.qatools.allure.annotations.Step;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.UsersOptions.USERS_OPTIONS;
//Task: 9250.

public class UsersOptionsSteps extends BasePpcSteps {

    @Step("DB: Oбновление записи в таблице ppc.user_options")
    public void updateUsersOptions(UsersOptionsRecord usersOptions) {
        run(db -> db.update(USERS_OPTIONS)
                .set(usersOptions)
                .where(USERS_OPTIONS.UID.eq(usersOptions.getUid()))
                .execute()
        );
    }

    @Step("DB: Oбновление поля options в таблице ppc.user_options, uid: {0}, options: {1}")
    public void setUsersOptions(Long uid, UserOptionsModel options) {
        UsersOptionsRecord usersOptions = getUsersOptions(uid);
        UserOptionsModel model = UserOptionsModel.fromString(usersOptions.getOptions());

        NullAwareBeanUtilsBean nullAwareBeanUtilsBean = new NullAwareBeanUtilsBean();
        try {
            nullAwareBeanUtilsBean.copyProperties(model, options);
        } catch (IllegalAccessException | InvocationTargetException e) {
            log().info("Не удалось установить новые значения опций", e);
            throw new DirectDbStepsException("Не удалось установить новые значения опций", e);
        }

        run(db -> db.update(USERS_OPTIONS)
                .set(USERS_OPTIONS.OPTIONS, options.toString())
                .where(USERS_OPTIONS.UID.eq(usersOptions.getUid()))
                .execute()
        );
    }

    @Step("DB: Получение записи в таблице ppc.user_options, uid: {0}")
    public UsersOptionsRecord getUsersOptions(Long uid) {
        return exec(db -> db.selectFrom(USERS_OPTIONS)
                .where(USERS_OPTIONS.UID.eq(uid))
                .fetchOne()
        );
    }
}
