package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersHidden;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersShowonyandexonly;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusarch;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusblocked;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusyandexadv;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.USERS;

public class UsersSteps extends BasePpcSteps {

    @Step("DB: Oбновление записи в таблице ppc.users")
    public void updateUsers(UsersRecord users) {
        run(db -> db.update(USERS)
                .set(users)
                .where(USERS.UID.eq(users.getUid()))
                .execute()
        );
    }

    @Step("DB: Выставление ppc.users.hidden = {1} для uid = {0}")
    public void setUsersHidden(Long uid, UsersHidden usersHidden) {
        run(db -> db.update(USERS)
                .set(USERS.HIDDEN, usersHidden)
                .where(USERS.UID.eq(uid))
                .execute()
        );
    }

    @Step("DB: Выставление ppc.users.statusArch = {1} для uid = {0}")
    public void setArchived(Long uid, UsersStatusarch usersStatusarch) {
        run(db -> db.update(USERS)
                .set(USERS.STATUSARCH, usersStatusarch)
                .where(USERS.UID.eq(uid))
                .execute()
        );
    }

    @Step("DB: Выставление ppc.users.statusBlocked = {1} для uid = {0}")
    public void setBlocked(Long uid, UsersStatusblocked usersStatusblocked) {
        run(db -> db.update(USERS)
                .set(USERS.STATUSBLOCKED, usersStatusblocked)
                .where(USERS.UID.eq(uid))
                .execute()
        );
    }

    @Step("DB: Выставление ppc.users.statusYandexAdv = {1}, showOnYandexOnly = {2} для uid = {0}")
    public void setOldInternalAdvFlags(Long uid,
                                       UsersStatusyandexadv statusYandexAdv,
                                       UsersShowonyandexonly showOnYandexOnly) {
        run(db -> db.update(USERS)
                .set(USERS.STATUSYANDEXADV, statusYandexAdv)
                .set(USERS.SHOWONYANDEXONLY, showOnYandexOnly)
                .where(USERS.UID.eq(uid))
                .execute()
        );
    }

    @Step("DB: Получение записи в таблице ppc.users, uid: {0}")
    public UsersRecord getUsers(Long uid) {
        return exec(db -> db.selectFrom(USERS)
                .where(USERS.UID.eq(uid))
                .fetchOne()
        );
    }

    @Step("DB: Получение записи в таблице ppc.users, login: {0}")
    public UsersRecord getUser(String login) {
        return exec(db -> db.selectFrom(USERS)
                .where(USERS.LOGIN.eq(login))
                .fetchOne()
        );
    }

    @Step("DB: Получение записи в таблице ppc.users, uid: {0}")
    public UsersRecord getUsersByClientId(Long clientId) {
        return exec(db -> db.selectFrom(USERS)
                .where(USERS.CLIENTID.eq(clientId))
                .fetchOne()
        );
    }

    @Step("DB: Получение uid'ов представителей клиента, clientid: {0}")
    public List<Long> getAllUidsByClientId(Long clientId) {
        return exec(db -> db.selectFrom(USERS)
                .where(USERS.CLIENTID.eq(clientId))
                .fetch(USERS.UID)
        );
    }

    @Step("DB: Получение uid'ов по логину: {0}")
    public Long getUidByLogin(String login) {
        return exec(db -> db.selectFrom(USERS)
                .where(USERS.LOGIN.eq(login))
                .fetchOne(USERS.UID)
        );
    }

    @Step("DB: Удаление записи в таблице ppc.users")
    public void deleteUserByClientId(Long clientId) {
        run(db -> db.deleteFrom(USERS)
                .where(USERS.CLIENTID.eq(clientId))
                .execute()
        );
    }
}
