package ru.yandex.autotests.direct.db.steps;

import java.math.BigDecimal;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DomainVcardsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.VcardsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.DomainVcards.DOMAIN_VCARDS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Vcards.VCARDS;

public class VCardSteps extends BasePpcSteps {

    @Step("DB: Получение записи в таблице ppc.vcards, vid: {0}")
    public VcardsRecord getVCards(Long vid) {
        return exec(db -> db.selectFrom(VCARDS)
                .where(VCARDS.VCARD_ID.eq(vid))
                .fetchOne()
        );
    }

    @Step("DB: Получение записи в таблице ppc.vcards, cid: {0}")
    public VcardsRecord getVCardsByCid(Long cid) {
        return exec(db -> db.selectFrom(VCARDS)
                .where(VCARDS.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: Получение записи в таблице ppc.domain_vcards, domain: {0}")
    public DomainVcardsRecord getDomainVCardsByDomain(String domain) {
        return exec(db -> db.selectFrom(DOMAIN_VCARDS)
                .where(DOMAIN_VCARDS.DOMAIN.eq(domain))
                .fetchOne()
        );
    }

    @Step("DB: Создание записи в таблице ppc.domain_vcards")
    public void saveDomainVCards(DomainVcardsRecord domainVcardsRecord) {
        exec(db -> db.insertInto(DOMAIN_VCARDS)
                .set(domainVcardsRecord)
                .execute());
    }

    @Step("DB: Создание записи с тестовыми данными в таблице ppc.domain_vcards, если ее еще нет (domain = {0})")
    public void saveFakeDomainVCardsForDomain(String domain) {
        //если в таблице нет искомого домена
        if (getDomainVCardsByDomain(domain) == null) {
            DomainVcardsRecord fakeDomainVcardsRecord = new DomainVcardsRecord()
                    .setDomain(domain)
                    .setAddress("Saint Petersburg, ul. Razyezzhaya, 5")
                    .setPrecision("exact")
                    .setX(BigDecimal.valueOf(30.343366f))
                    .setX1(BigDecimal.valueOf(30.343366f))
                    .setX2(BigDecimal.valueOf(30.343366f))
                    .setY(BigDecimal.valueOf(59.925209f))
                    .setY1(BigDecimal.valueOf(59.925209f))
                    .setY2(BigDecimal.valueOf(59.925209f));

            saveDomainVCards(fakeDomainVcardsRecord);
        }
    }

}
