package ru.yandex.autotests.direct.db.steps;

import org.apache.commons.lang3.RandomStringUtils;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.WalletPaymentTransactionsStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.WalletPaymentTransactionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.WalletPaymentTransactionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.WalletPaymentTransactions.WALLET_PAYMENT_TRANSACTIONS;


/*
* todo javadoc
*/
public class WalletPaymentTransactionsSteps extends BasePpcSteps {

    @Step("DB: чтение записи из таблицы ppc.wallet_payment_transactions, id={0}")
    public WalletPaymentTransactionsRecord getWalletPaymentTransactions(Long id) {
        return exec(db -> db.selectFrom(WALLET_PAYMENT_TRANSACTIONS)
                .where(WALLET_PAYMENT_TRANSACTIONS.ID.eq(id))
                .fetchOne()
        );
    }

    @Step("DB: чтение записи из таблицы ppc.wallet_payment_transactions, wallet_cid={0}")
    public List<WalletPaymentTransactionsRecord> getWalletPaymentTransactionsByWalletCid(Long walletCid) {
        return exec(db -> db.selectFrom(WALLET_PAYMENT_TRANSACTIONS)
                .where(WALLET_PAYMENT_TRANSACTIONS.WALLET_CID.eq(walletCid))
                .fetch()
        );
    }

    @Step("DB: изменение записи в таблице ppc.wallet_payment_transactions")
    public void updateWalletPaymentTransactions(WalletPaymentTransactionsRecord walletPaymentTransactionsRecord) {
        run(db -> db.update(WALLET_PAYMENT_TRANSACTIONS)
                .set(walletPaymentTransactionsRecord)
                .where(WALLET_PAYMENT_TRANSACTIONS.WALLET_CID.eq(walletPaymentTransactionsRecord.getWalletCid()))
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.wallet_payment_transactions")
    public void saveWalletPaymentTransactions(
            WalletPaymentTransactionsRecord walletPaymentTransactionsRecord) {
        run(db -> db.insertInto(WALLET_PAYMENT_TRANSACTIONS)
                .set(walletPaymentTransactionsRecord)
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.wallet_payment_transactions")
    public WalletPaymentTransactionsRecord saveDefaultAutoWalletPaymentTransactions(Long walletCid, Long uid
            , WalletPaymentTransactionsStatus status, String balanceStatus, String balanceStatusCode, Long balanceTid) {
        saveWalletPaymentTransactions(new WalletPaymentTransactionsRecord()
                .setPayerUid(uid)
                .setWalletCid(walletCid)
                .setBalanceStatus(balanceStatus)
                .setType(WalletPaymentTransactionsType.auto)
                .setStatus(status)
                .setTrustPaymentId(RandomStringUtils.randomAlphanumeric(24))
                .setParams("".getBytes())
                .setBalanceStatusCode(balanceStatusCode)
                .setTotalBalanceTid(balanceTid));
        return getWalletPaymentTransactionsByWalletCid(walletCid)
                .stream()
                .max((o1, o2) -> Long.compare(o1.getId(), o2.getId()))
                .get();
    }


    public WalletPaymentTransactionsRecord saveDefaultAutoWalletPaymentTransactions(Long walletCid, Long uid
            , WalletPaymentTransactionsStatus status, String balanceStatus) {
        return saveDefaultAutoWalletPaymentTransactions(walletCid, uid, status, balanceStatus, "", 1L);
    }

    public WalletPaymentTransactionsRecord saveDefaultAutoWalletPaymentTransactions(Long walletCid, Long uid
            , WalletPaymentTransactionsStatus status, String balanceStatus, Long totalBalanceTid) {
        return saveDefaultAutoWalletPaymentTransactions(walletCid, uid, status, balanceStatus, "", totalBalanceTid);
    }

    @Step("DB: удаление записи из таблицы ppc.wallet_payment_transactions")
    public void deleteWalletPaymentTransactions(WalletPaymentTransactionsRecord walletPaymentTransactionsRecord) {
        run(db -> db.deleteFrom(WALLET_PAYMENT_TRANSACTIONS)
                .where(WALLET_PAYMENT_TRANSACTIONS.ID.eq(walletPaymentTransactionsRecord.getId()))
                .execute());
    }

    @Step("DB: удаление всех записей из таблицы ppc.wallet_payment_transactions для walletCid={0}")
    public void deleteWalletPaymentTransactionsByCid(Long walletCid) {
        run(db -> db.deleteFrom(WALLET_PAYMENT_TRANSACTIONS)
                .where(WALLET_PAYMENT_TRANSACTIONS.WALLET_CID.eq(walletCid))
                .execute());
    }
}
