package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.YandexAgencyOrdersYaorderstatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.YandexAgencyOrdersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.YandexAgencyOrders.YANDEX_AGENCY_ORDERS;

public class YandexAgencyOrdersSteps extends BasePpcSteps {
    @Step("DB: создание записи в таблице ppc.yandex_agency_orders")
    public void saveYandexAgencyOrder(YandexAgencyOrdersRecord yandexAgencyOrdersRecord) {
        run(db ->
                db.insertInto(YANDEX_AGENCY_ORDERS)
                        .set(yandexAgencyOrdersRecord)
                        .execute());
    }

    @Step("DB: изменение записи в таблице ppc.yandex_agency_orders")
    public void updateYandexAgencyOrder(YandexAgencyOrdersRecord yandexAgencyOrdersRecord) {
        run(db ->
                db.update(YANDEX_AGENCY_ORDERS)
                        .set(yandexAgencyOrdersRecord)
                        .where(YANDEX_AGENCY_ORDERS.YAORDERID.eq(yandexAgencyOrdersRecord.getYaorderid()))
                        .execute());
    }

    @Step("DB: изменение статуса заказа: {0} в таблице ppc.yandex_agency_orders по clientId: {1}")
    public void setYandexAgencyOrderStatus(YandexAgencyOrdersYaorderstatus status, Long clientId) {
        run(db ->
                db.update(YANDEX_AGENCY_ORDERS)
                        .set(YANDEX_AGENCY_ORDERS.YAORDERSTATUS, status)
                        .where(YANDEX_AGENCY_ORDERS.CLIENTID.eq(clientId))
                        .execute());
    }

    @Step("DB: получение записи из таблице ppc.yandex_agency_orders по orderId: {0}")
    public YandexAgencyOrdersRecord getYandexAgencyOrderByOrderId(Long orderId) {
        return exec(db -> db.selectFrom(YANDEX_AGENCY_ORDERS)
                .where(YANDEX_AGENCY_ORDERS.YAORDERID.eq(orderId))
                .fetchOne()
        );
    }

    @Step("DB: получение записи из таблице ppc.yandex_agency_orders по clientId: {0}")
    public YandexAgencyOrdersRecord getYandexAgencyOrderByClientId(Long clientId) {
        return exec(db -> db.selectFrom(YANDEX_AGENCY_ORDERS)
                .where(YANDEX_AGENCY_ORDERS.CLIENTID.eq(clientId))
                .fetchOne()
        );
    }


}
