package ru.yandex.autotests.direct.db.steps.base;


import org.jooq.DatePart;
import org.jooq.impl.DSL;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CurrencyConvertQueueConvertType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CurrencyConvertQueueNewCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CurrencyConvertQueueState;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CurrencyConvertQueueRecord;
import ru.yandex.qatools.allure.annotations.Step;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CurrencyConvertQueue.CURRENCY_CONVERT_QUEUE;


/**
 * Created by voronov on 16.08.2016.
 */

public class CurrencyConvertQueueSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.currency_convert_queue (clientId = {0})")
    public CurrencyConvertQueueRecord getCurrencyConvertQueue(Long clientId) {
        return exec(db -> db.selectFrom(CURRENCY_CONVERT_QUEUE)
                .where(CURRENCY_CONVERT_QUEUE.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.currency_convert_queue")
    public void createCurrencyConvertQueue(CurrencyConvertQueueRecord record) {
        exec(db -> db.insertInto(CURRENCY_CONVERT_QUEUE)
                .set(record)
                .execute());
    }

    @Step("DB: удаление записи в таблице ppc.currency_convert_queue")
    public void deleteCurrencyConvertQueue(Long clientId) {
        exec(db -> db.deleteFrom(CURRENCY_CONVERT_QUEUE)
                .where(CURRENCY_CONVERT_QUEUE.CLIENTID.eq(clientId))
                .execute());
    }

    @Step("DB: Запустить процесс конвертации валют для клиента (ppc.currency_convert_queue)")
    public void startConvertingCurrency(Long clientId, int delayInMin) {
        exec(db -> db.insertInto(CURRENCY_CONVERT_QUEUE)
                .set(CURRENCY_CONVERT_QUEUE.CLIENTID, clientId)
                .set(CURRENCY_CONVERT_QUEUE.CONVERT_TYPE, CurrencyConvertQueueConvertType.COPY)
                .set(CURRENCY_CONVERT_QUEUE.NEW_CURRENCY, CurrencyConvertQueueNewCurrency.RUB)
                .set(CURRENCY_CONVERT_QUEUE.COUNTRY_REGION_ID, 0L)
                .set(
                        CURRENCY_CONVERT_QUEUE.START_CONVERT_AT,
                        DSL.timestampAdd(DSL.currentTimestamp(), delayInMin, DatePart.MINUTE))
                .set(CURRENCY_CONVERT_QUEUE.STATE, CurrencyConvertQueueState.NEW)
                .onDuplicateKeyUpdate()
                .set(CURRENCY_CONVERT_QUEUE.START_CONVERT_AT, Timestamp.from(Instant.now().plus(10, ChronoUnit.MINUTES)))
                .set(CURRENCY_CONVERT_QUEUE.STATE, CurrencyConvertQueueState.NEW)
                .execute());
    }
}
